/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.api.util;

import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerErrorException;
import io.camunda.zeebe.broker.client.api.BrokerRejectionException;
import io.camunda.zeebe.broker.client.api.BrokerResponseConsumer;
import io.camunda.zeebe.broker.client.api.BrokerResponseException;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.api.IllegalBrokerResponseException;
import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.gateway.api.util.StubbedTopologyManager;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;

public final class StubbedBrokerClient
implements BrokerClient {
    final BrokerTopologyManager topologyManager = new StubbedTopologyManager();
    private Consumer<String> jobsAvailableHandler;
    private final Map<Class<?>, RequestHandler<?, ?>> requestHandlers = new HashMap();
    private final List<BrokerRequest<?>> brokerRequests = new ArrayList();

    public Collection<ActorFuture<Void>> start() {
        return null;
    }

    public void close() {
    }

    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        return this.sendRequestWithRetry(request);
    }

    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request, Duration requestTimeout) {
        return this.sendRequestWithRetry(request);
    }

    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request) {
        CompletableFuture future = new CompletableFuture();
        this.sendRequestWithRetry(request, (key, response) -> future.complete(new BrokerResponse(response, Protocol.decodePartitionId((long)key), key)), future::completeExceptionally);
        return future;
    }

    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request, Duration requestTimeout) {
        CompletableFuture result = new CompletableFuture();
        this.sendRequestWithRetry(request, (key, response) -> result.complete(new BrokerResponse(response, Protocol.decodePartitionId((long)key), key)), result::completeExceptionally);
        return result.orTimeout(requestTimeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public <T> void sendRequestWithRetry(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        block7: {
            this.brokerRequests.add(request);
            try {
                RequestHandler<?, ?> requestHandler = this.requestHandlers.get(request.getClass());
                Object response = requestHandler.handle(request);
                try {
                    if (response.isResponse()) {
                        responseConsumer.accept(response.getKey(), response.getResponse());
                        break block7;
                    }
                    if (response.isRejection()) {
                        throwableConsumer.accept((Throwable)new BrokerRejectionException(response.getRejection()));
                        break block7;
                    }
                    if (response.isError()) {
                        throwableConsumer.accept((Throwable)new BrokerErrorException(response.getError()));
                        break block7;
                    }
                    throwableConsumer.accept((Throwable)new IllegalBrokerResponseException("Expected broker response to be either response, rejection, or error, but is neither of them []"));
                }
                catch (RuntimeException e) {
                    throwableConsumer.accept((Throwable)new BrokerResponseException((Throwable)e));
                }
            }
            catch (Exception e) {
                throwableConsumer.accept((Throwable)new BrokerResponseException((Throwable)e));
            }
        }
    }

    public BrokerTopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    public void subscribeJobAvailableNotification(String topic, Consumer<String> handler) {
        this.jobsAvailableHandler = handler;
    }

    public <RequestT extends BrokerRequest<?>, ResponseT extends BrokerResponse<?>> void registerHandler(Class<?> requestType, RequestHandler<RequestT, ResponseT> requestHandler) {
        this.requestHandlers.put(requestType, requestHandler);
    }

    public void notifyJobsAvailable(String type) {
        this.jobsAvailableHandler.accept(type);
    }

    public <T extends BrokerRequest<?>> T getSingleBrokerRequest() {
        Assertions.assertThat(this.brokerRequests).hasSize(1);
        return (T)this.brokerRequests.get(0);
    }

    public List<BrokerRequest<?>> getBrokerRequests() {
        return this.brokerRequests;
    }

    @FunctionalInterface
    public static interface RequestHandler<RequestT extends BrokerRequest<?>, ResponseT extends BrokerResponse<?>> {
        public ResponseT handle(RequestT var1) throws Exception;
    }

    public static interface RequestStub<RequestT extends BrokerRequest<?>, ResponseT extends BrokerResponse<?>>
    extends RequestHandler<RequestT, ResponseT> {
        public void registerWith(StubbedBrokerClient var1);
    }
}

