/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.api.job;

import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.gateway.api.util.StubbedBrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.LongStream;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ActivateJobsStub
implements StubbedBrokerClient.RequestStub<BrokerActivateJobsRequest, BrokerResponse<JobBatchRecord>> {
    public static final long JOB_BATCH_KEY = 123L;
    public static final int RETRIES = 12;
    public static final long DEADLINE = 123123123L;
    public static final long PROCESS_INSTANCE_KEY = 123L;
    public static final String BPMN_PROCESS_ID = "stubProcess";
    public static final int PROCESS_DEFINITION_VERSION = 23;
    public static final long PROCESS_KEY = 4532L;
    public static final String ELEMENT_ID = "stubActivity";
    public static final long ELEMENT_INSTANCE_KEY = 459L;
    public static final String CUSTOM_HEADERS = "{\"foo\": 12, \"bar\": \"val\"}";
    public static final String VARIABLES = "{\"foo\": 13, \"bar\": \"world\"}";
    public static final DirectBuffer CUSTOM_HEADERS_MSGPACK = new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)"{\"foo\": 12, \"bar\": \"val\"}"));
    public static final DirectBuffer VARIABLES_MSGPACK = new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)"{\"foo\": 13, \"bar\": \"world\"}"));
    private final Map<String, Integer> availableJobs = new ConcurrentHashMap<String, Integer>();

    public long getJobBatchKey() {
        return 123L;
    }

    public int getRetries() {
        return 12;
    }

    public long getDeadline() {
        return 123123123L;
    }

    public String getCustomHeaders() {
        return CUSTOM_HEADERS;
    }

    public String getVariables() {
        return VARIABLES;
    }

    public long getProcessInstanceKey() {
        return 123L;
    }

    public String getBpmnProcessId() {
        return BPMN_PROCESS_ID;
    }

    public int getProcessDefinitionVersion() {
        return 23;
    }

    public long getProcessDefinitionKey() {
        return 4532L;
    }

    public String getElementId() {
        return ELEMENT_ID;
    }

    public long getElementInstanceKey() {
        return 459L;
    }

    @Override
    public BrokerResponse<JobBatchRecord> handle(BrokerActivateJobsRequest request) throws Exception {
        int partitionId = request.getPartitionId();
        JobBatchRecord requestDto = request.getRequestWriter();
        JobBatchRecord response = new JobBatchRecord();
        response.setMaxJobsToActivate(requestDto.getMaxJobsToActivate());
        response.setWorker(requestDto.getWorkerBuffer());
        response.setType(requestDto.getTypeBuffer());
        response.setTimeout(requestDto.getTimeout());
        this.addJobs(response, partitionId, requestDto.getMaxJobsToActivate(), requestDto.getTypeBuffer(), requestDto.getWorkerBuffer(), requestDto.getTenantIds());
        return new BrokerResponse((Object)response, partitionId, Protocol.encodePartitionId((int)partitionId, (long)123L));
    }

    public void addAvailableJobs(String type, int amount) {
        this.availableJobs.put(type, amount);
    }

    private void addJobs(JobBatchRecord response, int partitionId, int amount, DirectBuffer type, DirectBuffer worker, List<String> tenantIds) {
        int availableAmount = this.availableJobs.computeIfAbsent(BufferUtil.bufferAsString((DirectBuffer)type), k -> 0);
        int jobsToActivate = Math.min(amount, availableAmount);
        this.availableJobs.put(BufferUtil.bufferAsString((DirectBuffer)type), availableAmount - jobsToActivate);
        LongStream.range(0L, jobsToActivate).forEach(key -> {
            ((LongValue)response.jobKeys().add()).setValue(Protocol.encodePartitionId((int)partitionId, (long)key));
            JobRecord job = (JobRecord)response.jobs().add();
            job.setType(type).setWorker(worker).setRetries(12).setDeadline(123123123L).setCustomHeaders(CUSTOM_HEADERS_MSGPACK).setVariables(VARIABLES_MSGPACK).setProcessInstanceKey(123L).setBpmnProcessId(BPMN_PROCESS_ID).setProcessDefinitionVersion(23).setProcessDefinitionKey(4532L).setElementId(ELEMENT_ID).setElementInstanceKey(459L);
            int tenantCount = tenantIds.size();
            if (tenantCount > 0) {
                job.setTenantId((String)tenantIds.get((int)key % tenantCount));
            }
        });
    }

    @Override
    public void registerWith(StubbedBrokerClient gateway) {
        gateway.registerHandler(BrokerActivateJobsRequest.class, this);
    }
}

