/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import io.camunda.zeebe.feel.impl.Loggers;
import io.camunda.zeebe.feel.impl.MessagePackContext;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.camunda.feel.context.Context;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValDate;
import org.camunda.feel.syntaxtree.ValDateTime;
import org.camunda.feel.syntaxtree.ValDayTimeDuration;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValLocalDateTime;
import org.camunda.feel.syntaxtree.ValLocalTime;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.syntaxtree.ValTime;
import org.camunda.feel.syntaxtree.ValYearMonthDuration;
import scala.collection.immutable.Map;

public class FeelToMessagePackTransformer {
    final MsgPackWriter writer = new MsgPackWriter();
    final MutableDirectBuffer writeBuffer = new ExpandableArrayBuffer();
    final DirectBuffer resultView = new UnsafeBuffer();
    final DirectBuffer stringWrapper = new UnsafeBuffer();

    public DirectBuffer toMessagePack(Val value) {
        this.writer.wrap(this.writeBuffer, 0);
        this.writeValue(value);
        this.resultView.wrap((DirectBuffer)this.writeBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    private void writeValue(Val value) {
        Val val = value;
        Objects.requireNonNull(val);
        Val val2 = val;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValNull$.class, ValNumber.class, ValBoolean.class, ValString.class, ValList.class, ValContext.class, ValTime.class, ValLocalTime.class, ValDate.class, ValDateTime.class, ValLocalDateTime.class, ValDayTimeDuration.class, ValYearMonthDuration.class}, (Object)val2, n)) {
            case 0: {
                ValNull$ ignored = (ValNull$)val2;
                this.writer.writeNil();
                break;
            }
            case 1: {
                ValNumber number = (ValNumber)val2;
                if (number.value().isWhole()) {
                    this.writer.writeInteger(number.value().longValue());
                    break;
                }
                this.writer.writeFloat(number.value().doubleValue());
                break;
            }
            case 2: {
                ValBoolean booleanValue = (ValBoolean)val2;
                this.writer.writeBoolean(booleanValue.value());
                break;
            }
            case 3: {
                ValString string = (ValString)val2;
                this.writeStringValue(string.value());
                break;
            }
            case 4: {
                ValList list = (ValList)val2;
                this.writer.writeArrayHeader(list.items().size());
                list.items().foreach(item -> {
                    this.writeValue((Val)item);
                    return null;
                });
                break;
            }
            case 5: {
                ValContext context = (ValContext)val2;
                Context context2 = context.context();
                if (context2 instanceof MessagePackContext) {
                    MessagePackContext msgPackContext = (MessagePackContext)context2;
                    this.writer.writeRaw(msgPackContext.messagePackMap);
                    break;
                }
                Map variables = context.context().variableProvider().getVariables();
                this.writer.writeMapHeader(variables.size());
                variables.foreach(entry -> {
                    String entryKey = (String)entry._1();
                    Object entryValue = entry._2();
                    this.stringWrapper.wrap(entryKey.getBytes());
                    this.writer.writeString(this.stringWrapper);
                    Object object = entryValue;
                    Objects.requireNonNull(object);
                    Object selector0$temp = object;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Val.class, DirectBuffer.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            Val entryVal = (Val)selector0$temp;
                            this.writeValue(entryVal);
                            break;
                        }
                        case 1: {
                            DirectBuffer entryBuffer = (DirectBuffer)selector0$temp;
                            this.writer.writeRaw(entryBuffer);
                            break;
                        }
                        default: {
                            this.writer.writeNil();
                            Loggers.LOGGER.trace("No FEEL to MessagePack transformation for '{}'. Using 'null' for context entry with key '{}'.", entryValue, (Object)entryKey);
                        }
                    }
                    return null;
                });
                break;
            }
            case 6: {
                ValTime time = (ValTime)val2;
                this.writeStringValue(time.value().format());
                break;
            }
            case 7: {
                ValLocalTime time = (ValLocalTime)val2;
                this.writeStringValue(time.value().toString());
                break;
            }
            case 8: {
                ValDate date = (ValDate)val2;
                this.writeStringValue(date.value().toString());
                break;
            }
            case 9: {
                ValDateTime dateTime = (ValDateTime)val2;
                this.writeStringValue(dateTime.value().toString());
                break;
            }
            case 10: {
                ValLocalDateTime dateTime = (ValLocalDateTime)val2;
                this.writeStringValue(dateTime.value().toString());
                break;
            }
            case 11: {
                ValDayTimeDuration duration = (ValDayTimeDuration)val2;
                this.writeStringValue(duration.toString());
                break;
            }
            case 12: {
                ValYearMonthDuration duration = (ValYearMonthDuration)val2;
                this.writeStringValue(duration.toString());
                break;
            }
            default: {
                this.writer.writeNil();
                Loggers.LOGGER.trace("No FEEL to MessagePack transformation for '{}'. Using 'null' instead.", (Object)value);
            }
        }
    }

    private void writeStringValue(String value) {
        this.stringWrapper.wrap(value.getBytes());
        this.writer.writeString(this.stringWrapper);
    }
}

