/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbException;
import io.camunda.zeebe.db.impl.rocksdb.Loggers;
import io.camunda.zeebe.protocol.EnumValue;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.agrona.CloseHelper;
import org.rocksdb.Checkpoint;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;

final class SnapshotOnlyDb<ColumnFamilyType extends Enum<? extends EnumValue>>
implements ZeebeDb<ColumnFamilyType> {
    private static final Logger LOG = Loggers.DB_LOGGER;
    private final RocksDB db;
    private final List<AutoCloseable> managedResources;

    public SnapshotOnlyDb(RocksDB db, List<AutoCloseable> managedResources) {
        this.db = db;
        this.managedResources = managedResources;
    }

    @Override
    public <KeyType extends DbKey, ValueType extends DbValue> ColumnFamily<KeyType, ValueType> createColumnFamily(ColumnFamilyType columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        throw this.unsupported("createColumnFamily");
    }

    @Override
    public void createSnapshot(File snapshotDir) {
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.db);){
            checkpoint.createCheckpoint(snapshotDir.getAbsolutePath());
        }
        catch (RocksDBException e) {
            throw new ZeebeDbException("Failed to take a RocksDB snapshot at '%s'".formatted(snapshotDir), e);
        }
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        throw this.unsupported("getProperty");
    }

    @Override
    public TransactionContext createContext() {
        throw this.unsupported("createContext");
    }

    @Override
    public boolean isEmpty(ColumnFamilyType column, TransactionContext context) {
        throw this.unsupported("isEmpty");
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        throw new UnsupportedOperationException("No meter registry is available for a snapshot only DB, as no metrics are collected.");
    }

    @Override
    public void close() {
        Collections.reverse(this.managedResources);
        CloseHelper.closeAll(error -> LOG.error("Failed to close RockDB resource, which may lead to leaked resources", error), this.managedResources);
    }

    static <ColumnFamilyType extends Enum<? extends EnumValue>> ZeebeDb<ColumnFamilyType> openDb(Options options, String path, List<AutoCloseable> managedResources) throws RocksDBException {
        RocksDB db = RocksDB.openReadOnly((Options)options, (String)path);
        managedResources.add((AutoCloseable)db);
        return new SnapshotOnlyDb<ColumnFamilyType>(db, managedResources);
    }

    private UnsupportedOperationException unsupported(String operation) {
        return new UnsupportedOperationException("Failed to execute 'ZeebeDb#%s'; this operation is not supported on a snapshot-only DB".formatted(operation));
    }
}

