/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.ColumnFamilyMetrics;
import io.camunda.zeebe.protocol.EnumValue;
import io.prometheus.client.Histogram;

public final class FineGrainedColumnFamilyMetrics
implements ColumnFamilyMetrics {
    private static final Histogram LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("rocksdb_latency")).exponentialBuckets(1.0E-5, 2.0, 15).labelNames(new String[]{"partition", "columnFamily", "operation"})).help("Latency of RocksDB operations per column family")).register();
    private final Histogram.Child getLatency;
    private final Histogram.Child putLatency;
    private final Histogram.Child deleteLatency;
    private final Histogram.Child iterateLatency;

    public <ColumnFamilyNames extends Enum<? extends EnumValue>> FineGrainedColumnFamilyMetrics(int partitionId, ColumnFamilyNames columnFamily) {
        String partitionLabel = String.valueOf(partitionId);
        String columnFamilyLabel = columnFamily.name();
        this.getLatency = (Histogram.Child)LATENCY.labels(new String[]{partitionLabel, columnFamilyLabel, "get"});
        this.putLatency = (Histogram.Child)LATENCY.labels(new String[]{partitionLabel, columnFamilyLabel, "put"});
        this.deleteLatency = (Histogram.Child)LATENCY.labels(new String[]{partitionLabel, columnFamilyLabel, "delete"});
        this.iterateLatency = (Histogram.Child)LATENCY.labels(new String[]{partitionLabel, columnFamilyLabel, "iterate"});
    }

    @Override
    public Histogram.Timer measureGetLatency() {
        return this.getLatency.startTimer();
    }

    @Override
    public Histogram.Timer measurePutLatency() {
        return this.putLatency.startTimer();
    }

    @Override
    public Histogram.Timer measureDeleteLatency() {
        return this.deleteLatency.startTimer();
    }

    @Override
    public Histogram.Timer measureIterateLatency() {
        return this.iterateLatency.startTimer();
    }
}

