/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.processor;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class ZeebeAnnotationProcessorRegistry
implements BeanPostProcessor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeAnnotationProcessorRegistry.class);
    private final Set<AbstractZeebeAnnotationProcessor> processors = new HashSet<AbstractZeebeAnnotationProcessor>();
    private final Map<String, Object> beans = new HashMap<String, Object>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractZeebeAnnotationProcessor) {
            AbstractZeebeAnnotationProcessor processor = (AbstractZeebeAnnotationProcessor)bean;
            LOG.debug("Found processor: {}", (Object)beanName);
            this.processors.add(processor);
        } else {
            this.beans.put(beanName, bean);
        }
        return bean;
    }

    public List<AbstractZeebeAnnotationProcessor> getProcessors() {
        return new ArrayList<AbstractZeebeAnnotationProcessor>(this.processors);
    }

    public void startAll(ZeebeClient zeebeClient) {
        this.processBeans();
        this.processors.forEach(zeebePostProcessor -> zeebePostProcessor.start(zeebeClient));
    }

    public void stopAll(ZeebeClient zeebeClient) {
        this.processors.forEach(zeebePostProcessor -> zeebePostProcessor.stop(zeebeClient));
    }

    private void processBeans() {
        this.beans.forEach((beanName, bean) -> {
            ClassInfo classInfo = ClassInfo.builder().bean(bean).beanName((String)beanName).build();
            for (AbstractZeebeAnnotationProcessor zeebePostProcessor : this.processors) {
                if (!zeebePostProcessor.isApplicableFor(classInfo)) continue;
                LOG.debug("Configuring bean {} with post processor {}", beanName, (Object)zeebePostProcessor.getBeanName());
                zeebePostProcessor.configureFor(classInfo);
            }
        });
        this.beans.clear();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

