/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.Partition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"nodeId", "host", "port", "partitions", "version"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BrokerInfo {
    public static final String JSON_PROPERTY_NODE_ID = "nodeId";
    @Nonnull
    private Integer nodeId;
    public static final String JSON_PROPERTY_HOST = "host";
    @Nonnull
    private String host;
    public static final String JSON_PROPERTY_PORT = "port";
    @Nonnull
    private Integer port;
    public static final String JSON_PROPERTY_PARTITIONS = "partitions";
    @Nonnull
    private List<Partition> partitions = new ArrayList<Partition>();
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nonnull
    private String version;

    public BrokerInfo nodeId(@Nonnull Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="nodeId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getNodeId() {
        return this.nodeId;
    }

    @JsonProperty(value="nodeId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNodeId(@Nonnull Integer nodeId) {
        this.nodeId = nodeId;
    }

    public BrokerInfo host(@Nonnull String host) {
        this.host = host;
        return this;
    }

    @Nonnull
    @JsonProperty(value="host", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHost(@Nonnull String host) {
        this.host = host;
    }

    public BrokerInfo port(@Nonnull Integer port) {
        this.port = port;
        return this;
    }

    @Nonnull
    @JsonProperty(value="port", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPort(@Nonnull Integer port) {
        this.port = port;
    }

    public BrokerInfo partitions(@Nonnull List<Partition> partitions) {
        this.partitions = partitions;
        return this;
    }

    public BrokerInfo addPartitionsItem(Partition partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<Partition>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="partitions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    @JsonProperty(value="partitions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPartitions(@Nonnull List<Partition> partitions) {
        this.partitions = partitions;
    }

    public BrokerInfo version(@Nonnull String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @JsonProperty(value="version", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersion(@Nonnull String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerInfo brokerInfo = (BrokerInfo)o;
        return Objects.equals(this.nodeId, brokerInfo.nodeId) && Objects.equals(this.host, brokerInfo.host) && Objects.equals(this.port, brokerInfo.port) && Objects.equals(this.partitions, brokerInfo.partitions) && Objects.equals(this.version, brokerInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.host, this.port, this.partitions, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrokerInfo {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

