/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

/**
 * Defines the source element identifier for the move instruction. It can either be a
 * sourceElementId, or sourceElementInstanceKey.
 */
@JsonPropertyOrder({
  SourceElementInstruction.JSON_PROPERTY_SOURCE_TYPE,
  SourceElementInstruction.JSON_PROPERTY_SOURCE_ELEMENT_ID,
  SourceElementInstruction.JSON_PROPERTY_SOURCE_ELEMENT_INSTANCE_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
@JsonIgnoreProperties(
    value = "sourceType", // ignore manually set sourceType, it will be automatically generated by
    // Jackson during serialization
    allowSetters = true // allows the sourceType to be set during deserialization
    )
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "sourceType",
    visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = SourceElementIdInstruction.class, name = "byId"),
  @JsonSubTypes.Type(value = SourceElementInstanceKeyInstruction.class, name = "byKey"),
})
public class SourceElementInstruction {
  public static final String JSON_PROPERTY_SOURCE_TYPE = "sourceType";
  // The discriminator does not have Nullability-annotation since it is added during serialization
  // by the @JsonTypeName annotation
  private String sourceType;

  public static final String JSON_PROPERTY_SOURCE_ELEMENT_ID = "sourceElementId";
  @javax.annotation.Nonnull private String sourceElementId;

  public static final String JSON_PROPERTY_SOURCE_ELEMENT_INSTANCE_KEY = "sourceElementInstanceKey";
  @javax.annotation.Nonnull private String sourceElementInstanceKey;

  public SourceElementInstruction() {}

  public SourceElementInstruction sourceType(@javax.annotation.Nonnull String sourceType) {

    this.sourceType = sourceType;
    return this;
  }

  /**
   * The type of source element instruction.
   *
   * @return sourceType
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_SOURCE_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getSourceType() {
    return sourceType;
  }

  @JsonProperty(value = JSON_PROPERTY_SOURCE_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceType(@javax.annotation.Nonnull String sourceType) {
    this.sourceType = sourceType;
  }

  public SourceElementInstruction sourceElementId(
      @javax.annotation.Nonnull String sourceElementId) {

    this.sourceElementId = sourceElementId;
    return this;
  }

  /**
   * The id of the source element for the move instruction.
   *
   * @return sourceElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_SOURCE_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getSourceElementId() {
    return sourceElementId;
  }

  @JsonProperty(value = JSON_PROPERTY_SOURCE_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceElementId(@javax.annotation.Nonnull String sourceElementId) {
    this.sourceElementId = sourceElementId;
  }

  public SourceElementInstruction sourceElementInstanceKey(
      @javax.annotation.Nonnull String sourceElementInstanceKey) {

    this.sourceElementInstanceKey = sourceElementInstanceKey;
    return this;
  }

  /**
   * The source element instance key for the move instruction.
   *
   * @return sourceElementInstanceKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_SOURCE_ELEMENT_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getSourceElementInstanceKey() {
    return sourceElementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_SOURCE_ELEMENT_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceElementInstanceKey(
      @javax.annotation.Nonnull String sourceElementInstanceKey) {
    this.sourceElementInstanceKey = sourceElementInstanceKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourceElementInstruction sourceElementInstruction = (SourceElementInstruction) o;
    return Objects.equals(this.sourceType, sourceElementInstruction.sourceType)
        && Objects.equals(this.sourceElementId, sourceElementInstruction.sourceElementId)
        && Objects.equals(
            this.sourceElementInstanceKey, sourceElementInstruction.sourceElementInstanceKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceType, sourceElementId, sourceElementInstanceKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SourceElementInstruction {\n");
    sb.append("    sourceType: ").append(toIndentedString(sourceType)).append("\n");
    sb.append("    sourceElementId: ").append(toIndentedString(sourceElementId)).append("\n");
    sb.append("    sourceElementInstanceKey: ")
        .append(toIndentedString(sourceElementInstanceKey))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
