/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Instruction describing a move operation. This instruction will terminate active element instances
 * based on the sourceElementInstruction and activate a new element instance for each terminated one
 * at targetElementId. Note that, for multi-instance activities, only the multi-instance body
 * instances will activate new element instances at the target id.
 */
@JsonPropertyOrder({
  ProcessInstanceModificationMoveInstruction.JSON_PROPERTY_SOURCE_ELEMENT_INSTRUCTION,
  ProcessInstanceModificationMoveInstruction.JSON_PROPERTY_TARGET_ELEMENT_ID,
  ProcessInstanceModificationMoveInstruction.JSON_PROPERTY_ANCESTOR_SCOPE_INSTRUCTION,
  ProcessInstanceModificationMoveInstruction.JSON_PROPERTY_VARIABLE_INSTRUCTIONS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class ProcessInstanceModificationMoveInstruction {
  public static final String JSON_PROPERTY_SOURCE_ELEMENT_INSTRUCTION = "sourceElementInstruction";
  @javax.annotation.Nonnull private SourceElementInstruction sourceElementInstruction;

  public static final String JSON_PROPERTY_TARGET_ELEMENT_ID = "targetElementId";
  @javax.annotation.Nonnull private String targetElementId;

  public static final String JSON_PROPERTY_ANCESTOR_SCOPE_INSTRUCTION = "ancestorScopeInstruction";
  @javax.annotation.Nullable private AncestorScopeInstruction ancestorScopeInstruction;

  public static final String JSON_PROPERTY_VARIABLE_INSTRUCTIONS = "variableInstructions";

  @javax.annotation.Nullable
  private List<ModifyProcessInstanceVariableInstruction> variableInstructions = new ArrayList<>();

  public ProcessInstanceModificationMoveInstruction() {}

  public ProcessInstanceModificationMoveInstruction sourceElementInstruction(
      @javax.annotation.Nonnull SourceElementInstruction sourceElementInstruction) {

    this.sourceElementInstruction = sourceElementInstruction;
    return this;
  }

  /**
   * Get sourceElementInstruction
   *
   * @return sourceElementInstruction
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_SOURCE_ELEMENT_INSTRUCTION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public SourceElementInstruction getSourceElementInstruction() {
    return sourceElementInstruction;
  }

  @JsonProperty(value = JSON_PROPERTY_SOURCE_ELEMENT_INSTRUCTION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceElementInstruction(
      @javax.annotation.Nonnull SourceElementInstruction sourceElementInstruction) {
    this.sourceElementInstruction = sourceElementInstruction;
  }

  public ProcessInstanceModificationMoveInstruction targetElementId(
      @javax.annotation.Nonnull String targetElementId) {

    this.targetElementId = targetElementId;
    return this;
  }

  /**
   * The target element id.
   *
   * @return targetElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TARGET_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTargetElementId() {
    return targetElementId;
  }

  @JsonProperty(value = JSON_PROPERTY_TARGET_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTargetElementId(@javax.annotation.Nonnull String targetElementId) {
    this.targetElementId = targetElementId;
  }

  public ProcessInstanceModificationMoveInstruction ancestorScopeInstruction(
      @javax.annotation.Nullable AncestorScopeInstruction ancestorScopeInstruction) {

    this.ancestorScopeInstruction = ancestorScopeInstruction;
    return this;
  }

  /**
   * Get ancestorScopeInstruction
   *
   * @return ancestorScopeInstruction
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ANCESTOR_SCOPE_INSTRUCTION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AncestorScopeInstruction getAncestorScopeInstruction() {
    return ancestorScopeInstruction;
  }

  @JsonProperty(value = JSON_PROPERTY_ANCESTOR_SCOPE_INSTRUCTION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncestorScopeInstruction(
      @javax.annotation.Nullable AncestorScopeInstruction ancestorScopeInstruction) {
    this.ancestorScopeInstruction = ancestorScopeInstruction;
  }

  public ProcessInstanceModificationMoveInstruction variableInstructions(
      @javax.annotation.Nullable
          List<ModifyProcessInstanceVariableInstruction> variableInstructions) {

    this.variableInstructions = variableInstructions;
    return this;
  }

  public ProcessInstanceModificationMoveInstruction addVariableInstructionsItem(
      ModifyProcessInstanceVariableInstruction variableInstructionsItem) {
    if (this.variableInstructions == null) {
      this.variableInstructions = new ArrayList<>();
    }
    this.variableInstructions.add(variableInstructionsItem);
    return this;
  }

  /**
   * Instructions describing which variables to create or update.
   *
   * @return variableInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_VARIABLE_INSTRUCTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ModifyProcessInstanceVariableInstruction> getVariableInstructions() {
    return variableInstructions;
  }

  @JsonProperty(value = JSON_PROPERTY_VARIABLE_INSTRUCTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariableInstructions(
      @javax.annotation.Nullable
          List<ModifyProcessInstanceVariableInstruction> variableInstructions) {
    this.variableInstructions = variableInstructions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceModificationMoveInstruction processInstanceModificationMoveInstruction =
        (ProcessInstanceModificationMoveInstruction) o;
    return Objects.equals(
            this.sourceElementInstruction,
            processInstanceModificationMoveInstruction.sourceElementInstruction)
        && Objects.equals(
            this.targetElementId, processInstanceModificationMoveInstruction.targetElementId)
        && Objects.equals(
            this.ancestorScopeInstruction,
            processInstanceModificationMoveInstruction.ancestorScopeInstruction)
        && Objects.equals(
            this.variableInstructions,
            processInstanceModificationMoveInstruction.variableInstructions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        sourceElementInstruction, targetElementId, ancestorScopeInstruction, variableInstructions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceModificationMoveInstruction {\n");
    sb.append("    sourceElementInstruction: ")
        .append(toIndentedString(sourceElementInstruction))
        .append("\n");
    sb.append("    targetElementId: ").append(toIndentedString(targetElementId)).append("\n");
    sb.append("    ancestorScopeInstruction: ")
        .append(toIndentedString(ancestorScopeInstruction))
        .append("\n");
    sb.append("    variableInstructions: ")
        .append(toIndentedString(variableInstructions))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
