/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * Instructions for creating a process instance. The process definition can be specified either by
 * id or by key.
 */
@JsonPropertyOrder({
  ProcessInstanceCreationInstruction.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_VARIABLES,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_OPERATION_REFERENCE,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_START_INSTRUCTIONS,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_RUNTIME_INSTRUCTIONS,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_AWAIT_COMPLETION,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_FETCH_VARIABLES,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_REQUEST_TIMEOUT,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_TAGS,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_PROCESS_DEFINITION_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class ProcessInstanceCreationInstruction {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nonnull private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable private Integer processDefinitionVersion = -1;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private String tenantId;

  public static final String JSON_PROPERTY_OPERATION_REFERENCE = "operationReference";
  @javax.annotation.Nullable private Long operationReference;

  public static final String JSON_PROPERTY_START_INSTRUCTIONS = "startInstructions";

  @javax.annotation.Nullable
  private List<ProcessInstanceCreationStartInstruction> startInstructions = new ArrayList<>();

  public static final String JSON_PROPERTY_RUNTIME_INSTRUCTIONS = "runtimeInstructions";

  @javax.annotation.Nullable
  private List<ProcessInstanceCreationTerminateInstruction> runtimeInstructions = new ArrayList<>();

  public static final String JSON_PROPERTY_AWAIT_COMPLETION = "awaitCompletion";
  @javax.annotation.Nullable private Boolean awaitCompletion = false;

  public static final String JSON_PROPERTY_FETCH_VARIABLES = "fetchVariables";
  @javax.annotation.Nullable private List<String> fetchVariables = new ArrayList<>();

  public static final String JSON_PROPERTY_REQUEST_TIMEOUT = "requestTimeout";
  @javax.annotation.Nullable private Long requestTimeout = 0l;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable private Set<String> tags = new LinkedHashSet<>();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nonnull private String processDefinitionKey;

  public ProcessInstanceCreationInstruction() {}

  public ProcessInstanceCreationInstruction processDefinitionId(
      @javax.annotation.Nonnull String processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The BPMN process id of the process definition to start an instance of.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionId(@javax.annotation.Nonnull String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessInstanceCreationInstruction processDefinitionVersion(
      @javax.annotation.Nullable Integer processDefinitionVersion) {

    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the process. By default, the latest version of the process is used.
   *
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_VERSION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_VERSION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(
      @javax.annotation.Nullable Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceCreationInstruction variables(
      @javax.annotation.Nullable Map<String, Object> variables) {

    this.variables = variables;
    return this;
  }

  public ProcessInstanceCreationInstruction putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON object that will instantiate the variables for the root variable scope of the process
   * instance.
   *
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = false)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Object> getVariables() {
    return variables;
  }

  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = false)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable Map<String, Object> variables) {
    this.variables = variables;
  }

  public ProcessInstanceCreationInstruction tenantId(@javax.annotation.Nullable String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the process definition.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceCreationInstruction operationReference(
      @javax.annotation.Nullable Long operationReference) {

    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this
   * operation. Must be &gt; 0 if provided. minimum: 1
   *
   * @return operationReference
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_OPERATION_REFERENCE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getOperationReference() {
    return operationReference;
  }

  @JsonProperty(value = JSON_PROPERTY_OPERATION_REFERENCE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationReference(@javax.annotation.Nullable Long operationReference) {
    this.operationReference = operationReference;
  }

  public ProcessInstanceCreationInstruction startInstructions(
      @javax.annotation.Nullable List<ProcessInstanceCreationStartInstruction> startInstructions) {

    this.startInstructions = startInstructions;
    return this;
  }

  public ProcessInstanceCreationInstruction addStartInstructionsItem(
      ProcessInstanceCreationStartInstruction startInstructionsItem) {
    if (this.startInstructions == null) {
      this.startInstructions = new ArrayList<>();
    }
    this.startInstructions.add(startInstructionsItem);
    return this;
  }

  /**
   * List of start instructions. By default, the process instance will start at the start event. If
   * provided, the process instance will apply start instructions after it has been created.
   *
   * @return startInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_START_INSTRUCTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ProcessInstanceCreationStartInstruction> getStartInstructions() {
    return startInstructions;
  }

  @JsonProperty(value = JSON_PROPERTY_START_INSTRUCTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartInstructions(
      @javax.annotation.Nullable List<ProcessInstanceCreationStartInstruction> startInstructions) {
    this.startInstructions = startInstructions;
  }

  public ProcessInstanceCreationInstruction runtimeInstructions(
      @javax.annotation.Nullable
          List<ProcessInstanceCreationTerminateInstruction> runtimeInstructions) {

    this.runtimeInstructions = runtimeInstructions;
    return this;
  }

  public ProcessInstanceCreationInstruction addRuntimeInstructionsItem(
      ProcessInstanceCreationTerminateInstruction runtimeInstructionsItem) {
    if (this.runtimeInstructions == null) {
      this.runtimeInstructions = new ArrayList<>();
    }
    this.runtimeInstructions.add(runtimeInstructionsItem);
    return this;
  }

  /**
   * Runtime instructions (alpha). List of instructions that affect the runtime behavior of the
   * process instance. Refer to specific instruction types for more details. This parameter is an
   * alpha feature and may be subject to change in future releases.
   *
   * @return runtimeInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_RUNTIME_INSTRUCTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ProcessInstanceCreationTerminateInstruction> getRuntimeInstructions() {
    return runtimeInstructions;
  }

  @JsonProperty(value = JSON_PROPERTY_RUNTIME_INSTRUCTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuntimeInstructions(
      @javax.annotation.Nullable
          List<ProcessInstanceCreationTerminateInstruction> runtimeInstructions) {
    this.runtimeInstructions = runtimeInstructions;
  }

  public ProcessInstanceCreationInstruction awaitCompletion(
      @javax.annotation.Nullable Boolean awaitCompletion) {

    this.awaitCompletion = awaitCompletion;
    return this;
  }

  /**
   * Wait for the process instance to complete. If the process instance completion does not occur
   * within the requestTimeout, the request will be closed. This can lead to a 504 response status.
   * Disabled by default.
   *
   * @return awaitCompletion
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_AWAIT_COMPLETION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAwaitCompletion() {
    return awaitCompletion;
  }

  @JsonProperty(value = JSON_PROPERTY_AWAIT_COMPLETION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAwaitCompletion(@javax.annotation.Nullable Boolean awaitCompletion) {
    this.awaitCompletion = awaitCompletion;
  }

  public ProcessInstanceCreationInstruction fetchVariables(
      @javax.annotation.Nullable List<String> fetchVariables) {

    this.fetchVariables = fetchVariables;
    return this;
  }

  public ProcessInstanceCreationInstruction addFetchVariablesItem(String fetchVariablesItem) {
    if (this.fetchVariables == null) {
      this.fetchVariables = new ArrayList<>();
    }
    this.fetchVariables.add(fetchVariablesItem);
    return this;
  }

  /**
   * List of variables by name to be included in the response when awaitCompletion is set to true.
   * If empty, all visible variables in the root scope will be returned.
   *
   * @return fetchVariables
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_FETCH_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getFetchVariables() {
    return fetchVariables;
  }

  @JsonProperty(value = JSON_PROPERTY_FETCH_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFetchVariables(@javax.annotation.Nullable List<String> fetchVariables) {
    this.fetchVariables = fetchVariables;
  }

  public ProcessInstanceCreationInstruction requestTimeout(
      @javax.annotation.Nullable Long requestTimeout) {

    this.requestTimeout = requestTimeout;
    return this;
  }

  /**
   * Timeout (in ms) the request waits for the process to complete. By default or when set to 0, the
   * generic request timeout configured in the cluster is applied.
   *
   * @return requestTimeout
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_REQUEST_TIMEOUT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getRequestTimeout() {
    return requestTimeout;
  }

  @JsonProperty(value = JSON_PROPERTY_REQUEST_TIMEOUT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestTimeout(@javax.annotation.Nullable Long requestTimeout) {
    this.requestTimeout = requestTimeout;
  }

  public ProcessInstanceCreationInstruction tags(@javax.annotation.Nullable Set<String> tags) {

    this.tags = tags;
    return this;
  }

  public ProcessInstanceCreationInstruction addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags. Tags need to start with a letter; then alphanumerics, &#x60;_&#x60;,
   * &#x60;-&#x60;, &#x60;:&#x60;, or &#x60;.&#x60;; length ≤ 100.
   *
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<String> getTags() {
    return tags;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  public ProcessInstanceCreationInstruction processDefinitionKey(
      @javax.annotation.Nonnull String processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the process definition, for example, returned for a process in the
   * deploy resources endpoint.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionKey(@javax.annotation.Nonnull String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceCreationInstruction processInstanceCreationInstruction =
        (ProcessInstanceCreationInstruction) o;
    return Objects.equals(
            this.processDefinitionId, processInstanceCreationInstruction.processDefinitionId)
        && Objects.equals(
            this.processDefinitionVersion,
            processInstanceCreationInstruction.processDefinitionVersion)
        && Objects.equals(this.variables, processInstanceCreationInstruction.variables)
        && Objects.equals(this.tenantId, processInstanceCreationInstruction.tenantId)
        && Objects.equals(
            this.operationReference, processInstanceCreationInstruction.operationReference)
        && Objects.equals(
            this.startInstructions, processInstanceCreationInstruction.startInstructions)
        && Objects.equals(
            this.runtimeInstructions, processInstanceCreationInstruction.runtimeInstructions)
        && Objects.equals(this.awaitCompletion, processInstanceCreationInstruction.awaitCompletion)
        && Objects.equals(this.fetchVariables, processInstanceCreationInstruction.fetchVariables)
        && Objects.equals(this.requestTimeout, processInstanceCreationInstruction.requestTimeout)
        && Objects.equals(this.tags, processInstanceCreationInstruction.tags)
        && Objects.equals(
            this.processDefinitionKey, processInstanceCreationInstruction.processDefinitionKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        processDefinitionId,
        processDefinitionVersion,
        variables,
        tenantId,
        operationReference,
        startInstructions,
        runtimeInstructions,
        awaitCompletion,
        fetchVariables,
        requestTimeout,
        tags,
        processDefinitionKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceCreationInstruction {\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    processDefinitionVersion: ")
        .append(toIndentedString(processDefinitionVersion))
        .append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("    startInstructions: ").append(toIndentedString(startInstructions)).append("\n");
    sb.append("    runtimeInstructions: ")
        .append(toIndentedString(runtimeInstructions))
        .append("\n");
    sb.append("    awaitCompletion: ").append(toIndentedString(awaitCompletion)).append("\n");
    sb.append("    fetchVariables: ").append(toIndentedString(fetchVariables)).append("\n");
    sb.append("    requestTimeout: ").append(toIndentedString(requestTimeout)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
