/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** Process definition instance statistics response. */
@JsonPropertyOrder({
  ProcessDefinitionInstanceStatisticsResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessDefinitionInstanceStatisticsResult.JSON_PROPERTY_TENANT_ID,
  ProcessDefinitionInstanceStatisticsResult.JSON_PROPERTY_LATEST_PROCESS_DEFINITION_NAME,
  ProcessDefinitionInstanceStatisticsResult.JSON_PROPERTY_HAS_MULTIPLE_VERSIONS,
  ProcessDefinitionInstanceStatisticsResult.JSON_PROPERTY_ACTIVE_INSTANCES_WITHOUT_INCIDENT_COUNT,
  ProcessDefinitionInstanceStatisticsResult.JSON_PROPERTY_ACTIVE_INSTANCES_WITH_INCIDENT_COUNT
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class ProcessDefinitionInstanceStatisticsResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable private String processDefinitionId;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private String tenantId;

  public static final String JSON_PROPERTY_LATEST_PROCESS_DEFINITION_NAME =
      "latestProcessDefinitionName";
  @javax.annotation.Nullable private String latestProcessDefinitionName;

  public static final String JSON_PROPERTY_HAS_MULTIPLE_VERSIONS = "hasMultipleVersions";
  @javax.annotation.Nullable private Boolean hasMultipleVersions;

  public static final String JSON_PROPERTY_ACTIVE_INSTANCES_WITHOUT_INCIDENT_COUNT =
      "activeInstancesWithoutIncidentCount";
  @javax.annotation.Nullable private Long activeInstancesWithoutIncidentCount;

  public static final String JSON_PROPERTY_ACTIVE_INSTANCES_WITH_INCIDENT_COUNT =
      "activeInstancesWithIncidentCount";
  @javax.annotation.Nullable private Long activeInstancesWithIncidentCount;

  public ProcessDefinitionInstanceStatisticsResult() {}

  public ProcessDefinitionInstanceStatisticsResult processDefinitionId(
      @javax.annotation.Nullable String processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * Id of a process definition, from the model. Only ids of process definitions that are deployed
   * are useful.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessDefinitionInstanceStatisticsResult tenantId(
      @javax.annotation.Nullable String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The unique identifier of the tenant.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessDefinitionInstanceStatisticsResult latestProcessDefinitionName(
      @javax.annotation.Nullable String latestProcessDefinitionName) {

    this.latestProcessDefinitionName = latestProcessDefinitionName;
    return this;
  }

  /**
   * Name of the latest deployed process definition instance version.
   *
   * @return latestProcessDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_LATEST_PROCESS_DEFINITION_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLatestProcessDefinitionName() {
    return latestProcessDefinitionName;
  }

  @JsonProperty(value = JSON_PROPERTY_LATEST_PROCESS_DEFINITION_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatestProcessDefinitionName(
      @javax.annotation.Nullable String latestProcessDefinitionName) {
    this.latestProcessDefinitionName = latestProcessDefinitionName;
  }

  public ProcessDefinitionInstanceStatisticsResult hasMultipleVersions(
      @javax.annotation.Nullable Boolean hasMultipleVersions) {

    this.hasMultipleVersions = hasMultipleVersions;
    return this;
  }

  /**
   * Indicates whether multiple versions of this process definition instance are deployed.
   *
   * @return hasMultipleVersions
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_HAS_MULTIPLE_VERSIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasMultipleVersions() {
    return hasMultipleVersions;
  }

  @JsonProperty(value = JSON_PROPERTY_HAS_MULTIPLE_VERSIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasMultipleVersions(@javax.annotation.Nullable Boolean hasMultipleVersions) {
    this.hasMultipleVersions = hasMultipleVersions;
  }

  public ProcessDefinitionInstanceStatisticsResult activeInstancesWithoutIncidentCount(
      @javax.annotation.Nullable Long activeInstancesWithoutIncidentCount) {

    this.activeInstancesWithoutIncidentCount = activeInstancesWithoutIncidentCount;
    return this;
  }

  /**
   * Total number of currently active process instances of this definition that do not have
   * incidents.
   *
   * @return activeInstancesWithoutIncidentCount
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ACTIVE_INSTANCES_WITHOUT_INCIDENT_COUNT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getActiveInstancesWithoutIncidentCount() {
    return activeInstancesWithoutIncidentCount;
  }

  @JsonProperty(value = JSON_PROPERTY_ACTIVE_INSTANCES_WITHOUT_INCIDENT_COUNT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveInstancesWithoutIncidentCount(
      @javax.annotation.Nullable Long activeInstancesWithoutIncidentCount) {
    this.activeInstancesWithoutIncidentCount = activeInstancesWithoutIncidentCount;
  }

  public ProcessDefinitionInstanceStatisticsResult activeInstancesWithIncidentCount(
      @javax.annotation.Nullable Long activeInstancesWithIncidentCount) {

    this.activeInstancesWithIncidentCount = activeInstancesWithIncidentCount;
    return this;
  }

  /**
   * Total number of currently active process instances of this definition that have at least one
   * incident.
   *
   * @return activeInstancesWithIncidentCount
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ACTIVE_INSTANCES_WITH_INCIDENT_COUNT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getActiveInstancesWithIncidentCount() {
    return activeInstancesWithIncidentCount;
  }

  @JsonProperty(value = JSON_PROPERTY_ACTIVE_INSTANCES_WITH_INCIDENT_COUNT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveInstancesWithIncidentCount(
      @javax.annotation.Nullable Long activeInstancesWithIncidentCount) {
    this.activeInstancesWithIncidentCount = activeInstancesWithIncidentCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessDefinitionInstanceStatisticsResult processDefinitionInstanceStatisticsResult =
        (ProcessDefinitionInstanceStatisticsResult) o;
    return Objects.equals(
            this.processDefinitionId, processDefinitionInstanceStatisticsResult.processDefinitionId)
        && Objects.equals(this.tenantId, processDefinitionInstanceStatisticsResult.tenantId)
        && Objects.equals(
            this.latestProcessDefinitionName,
            processDefinitionInstanceStatisticsResult.latestProcessDefinitionName)
        && Objects.equals(
            this.hasMultipleVersions, processDefinitionInstanceStatisticsResult.hasMultipleVersions)
        && Objects.equals(
            this.activeInstancesWithoutIncidentCount,
            processDefinitionInstanceStatisticsResult.activeInstancesWithoutIncidentCount)
        && Objects.equals(
            this.activeInstancesWithIncidentCount,
            processDefinitionInstanceStatisticsResult.activeInstancesWithIncidentCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        processDefinitionId,
        tenantId,
        latestProcessDefinitionName,
        hasMultipleVersions,
        activeInstancesWithoutIncidentCount,
        activeInstancesWithIncidentCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessDefinitionInstanceStatisticsResult {\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    latestProcessDefinitionName: ")
        .append(toIndentedString(latestProcessDefinitionName))
        .append("\n");
    sb.append("    hasMultipleVersions: ")
        .append(toIndentedString(hasMultipleVersions))
        .append("\n");
    sb.append("    activeInstancesWithoutIncidentCount: ")
        .append(toIndentedString(activeInstancesWithoutIncidentCount))
        .append("\n");
    sb.append("    activeInstancesWithIncidentCount: ")
        .append(toIndentedString(activeInstancesWithIncidentCount))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
