/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

/** Provides information on a partition within a broker node. */
@JsonPropertyOrder({
  Partition.JSON_PROPERTY_PARTITION_ID,
  Partition.JSON_PROPERTY_ROLE,
  Partition.JSON_PROPERTY_HEALTH
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class Partition {
  public static final String JSON_PROPERTY_PARTITION_ID = "partitionId";
  @javax.annotation.Nonnull private Integer partitionId;

  /** Describes the Raft role of the broker for a given partition. */
  public enum RoleEnum {
    LEADER(String.valueOf("leader")),

    FOLLOWER(String.valueOf("follower")),

    INACTIVE(String.valueOf("inactive")),

    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    RoleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RoleEnum fromValue(String value) {
      for (RoleEnum b : RoleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_ROLE = "role";
  @javax.annotation.Nonnull private RoleEnum role;

  /** Describes the current health of the partition. */
  public enum HealthEnum {
    HEALTHY(String.valueOf("healthy")),

    UNHEALTHY(String.valueOf("unhealthy")),

    DEAD(String.valueOf("dead")),

    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    HealthEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static HealthEnum fromValue(String value) {
      for (HealthEnum b : HealthEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_HEALTH = "health";
  @javax.annotation.Nonnull private HealthEnum health;

  public Partition() {}

  public Partition partitionId(@javax.annotation.Nonnull Integer partitionId) {

    this.partitionId = partitionId;
    return this;
  }

  /**
   * The unique ID of this partition.
   *
   * @return partitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PARTITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getPartitionId() {
    return partitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PARTITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPartitionId(@javax.annotation.Nonnull Integer partitionId) {
    this.partitionId = partitionId;
  }

  public Partition role(@javax.annotation.Nonnull RoleEnum role) {

    this.role = role;
    return this;
  }

  /**
   * Describes the Raft role of the broker for a given partition.
   *
   * @return role
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ROLE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public RoleEnum getRole() {
    return role;
  }

  @JsonProperty(value = JSON_PROPERTY_ROLE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRole(@javax.annotation.Nonnull RoleEnum role) {
    this.role = role;
  }

  public Partition health(@javax.annotation.Nonnull HealthEnum health) {

    this.health = health;
    return this;
  }

  /**
   * Describes the current health of the partition.
   *
   * @return health
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_HEALTH, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public HealthEnum getHealth() {
    return health;
  }

  @JsonProperty(value = JSON_PROPERTY_HEALTH, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHealth(@javax.annotation.Nonnull HealthEnum health) {
    this.health = health;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Partition partition = (Partition) o;
    return Objects.equals(this.partitionId, partition.partitionId)
        && Objects.equals(this.role, partition.role)
        && Objects.equals(this.health, partition.health);
  }

  @Override
  public int hashCode() {
    return Objects.hash(partitionId, role, health);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Partition {\n");
    sb.append("    partitionId: ").append(toIndentedString(partitionId)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    health: ").append(toIndentedString(health)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
