/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** Message subscription search filter. */
@JsonPropertyOrder({
  MessageSubscriptionFilter.JSON_PROPERTY_MESSAGE_SUBSCRIPTION_KEY,
  MessageSubscriptionFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  MessageSubscriptionFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  MessageSubscriptionFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  MessageSubscriptionFilter.JSON_PROPERTY_ELEMENT_ID,
  MessageSubscriptionFilter.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  MessageSubscriptionFilter.JSON_PROPERTY_MESSAGE_SUBSCRIPTION_STATE,
  MessageSubscriptionFilter.JSON_PROPERTY_LAST_UPDATED_DATE,
  MessageSubscriptionFilter.JSON_PROPERTY_MESSAGE_NAME,
  MessageSubscriptionFilter.JSON_PROPERTY_CORRELATION_KEY,
  MessageSubscriptionFilter.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class MessageSubscriptionFilter {
  public static final String JSON_PROPERTY_MESSAGE_SUBSCRIPTION_KEY = "messageSubscriptionKey";
  @javax.annotation.Nullable private MessageSubscriptionKeyFilterProperty messageSubscriptionKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable private ProcessDefinitionKeyFilterProperty processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable private ProcessInstanceKeyFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable private StringFilterProperty elementId;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable private ElementInstanceKeyFilterProperty elementInstanceKey;

  public static final String JSON_PROPERTY_MESSAGE_SUBSCRIPTION_STATE = "messageSubscriptionState";

  @javax.annotation.Nullable
  private MessageSubscriptionStateFilterProperty messageSubscriptionState;

  public static final String JSON_PROPERTY_LAST_UPDATED_DATE = "lastUpdatedDate";
  @javax.annotation.Nullable private DateTimeFilterProperty lastUpdatedDate;

  public static final String JSON_PROPERTY_MESSAGE_NAME = "messageName";
  @javax.annotation.Nullable private StringFilterProperty messageName;

  public static final String JSON_PROPERTY_CORRELATION_KEY = "correlationKey";
  @javax.annotation.Nullable private StringFilterProperty correlationKey;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private StringFilterProperty tenantId;

  public MessageSubscriptionFilter() {}

  public MessageSubscriptionFilter messageSubscriptionKey(
      @javax.annotation.Nullable MessageSubscriptionKeyFilterProperty messageSubscriptionKey) {

    this.messageSubscriptionKey = messageSubscriptionKey;
    return this;
  }

  /**
   * The message subscription key associated with this message subscription.
   *
   * @return messageSubscriptionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_MESSAGE_SUBSCRIPTION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MessageSubscriptionKeyFilterProperty getMessageSubscriptionKey() {
    return messageSubscriptionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_MESSAGE_SUBSCRIPTION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageSubscriptionKey(
      @javax.annotation.Nullable MessageSubscriptionKeyFilterProperty messageSubscriptionKey) {
    this.messageSubscriptionKey = messageSubscriptionKey;
  }

  public MessageSubscriptionFilter processDefinitionKey(
      @javax.annotation.Nullable ProcessDefinitionKeyFilterProperty processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated with this correlated message subscription. This only
   * works for data created with 8.9 and later.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessDefinitionKeyFilterProperty getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(
      @javax.annotation.Nullable ProcessDefinitionKeyFilterProperty processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public MessageSubscriptionFilter processDefinitionId(
      @javax.annotation.Nullable StringFilterProperty processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated with this message subscription.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(
      @javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public MessageSubscriptionFilter processInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated with this message subscription.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessInstanceKeyFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public MessageSubscriptionFilter elementId(
      @javax.annotation.Nullable StringFilterProperty elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID associated with this message subscription.
   *
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    this.elementId = elementId;
  }

  public MessageSubscriptionFilter elementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty elementInstanceKey) {

    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The element instance key associated with this message subscription.
   *
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ElementInstanceKeyFilterProperty getElementInstanceKey() {
    return elementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public MessageSubscriptionFilter messageSubscriptionState(
      @javax.annotation.Nullable MessageSubscriptionStateFilterProperty messageSubscriptionState) {

    this.messageSubscriptionState = messageSubscriptionState;
    return this;
  }

  /**
   * The message subscription state.
   *
   * @return messageSubscriptionState
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_MESSAGE_SUBSCRIPTION_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MessageSubscriptionStateFilterProperty getMessageSubscriptionState() {
    return messageSubscriptionState;
  }

  @JsonProperty(value = JSON_PROPERTY_MESSAGE_SUBSCRIPTION_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageSubscriptionState(
      @javax.annotation.Nullable MessageSubscriptionStateFilterProperty messageSubscriptionState) {
    this.messageSubscriptionState = messageSubscriptionState;
  }

  public MessageSubscriptionFilter lastUpdatedDate(
      @javax.annotation.Nullable DateTimeFilterProperty lastUpdatedDate) {

    this.lastUpdatedDate = lastUpdatedDate;
    return this;
  }

  /**
   * The last updated date of the message subscription.
   *
   * @return lastUpdatedDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_LAST_UPDATED_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getLastUpdatedDate() {
    return lastUpdatedDate;
  }

  @JsonProperty(value = JSON_PROPERTY_LAST_UPDATED_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdatedDate(
      @javax.annotation.Nullable DateTimeFilterProperty lastUpdatedDate) {
    this.lastUpdatedDate = lastUpdatedDate;
  }

  public MessageSubscriptionFilter messageName(
      @javax.annotation.Nullable StringFilterProperty messageName) {

    this.messageName = messageName;
    return this;
  }

  /**
   * The name of the message associated with the message subscription.
   *
   * @return messageName
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_MESSAGE_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getMessageName() {
    return messageName;
  }

  @JsonProperty(value = JSON_PROPERTY_MESSAGE_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageName(@javax.annotation.Nullable StringFilterProperty messageName) {
    this.messageName = messageName;
  }

  public MessageSubscriptionFilter correlationKey(
      @javax.annotation.Nullable StringFilterProperty correlationKey) {

    this.correlationKey = correlationKey;
    return this;
  }

  /**
   * The correlation key of the message subscription.
   *
   * @return correlationKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CORRELATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getCorrelationKey() {
    return correlationKey;
  }

  @JsonProperty(value = JSON_PROPERTY_CORRELATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorrelationKey(@javax.annotation.Nullable StringFilterProperty correlationKey) {
    this.correlationKey = correlationKey;
  }

  public MessageSubscriptionFilter tenantId(
      @javax.annotation.Nullable StringFilterProperty tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The unique external tenant ID.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageSubscriptionFilter messageSubscriptionFilter = (MessageSubscriptionFilter) o;
    return Objects.equals(
            this.messageSubscriptionKey, messageSubscriptionFilter.messageSubscriptionKey)
        && Objects.equals(this.processDefinitionKey, messageSubscriptionFilter.processDefinitionKey)
        && Objects.equals(this.processDefinitionId, messageSubscriptionFilter.processDefinitionId)
        && Objects.equals(this.processInstanceKey, messageSubscriptionFilter.processInstanceKey)
        && Objects.equals(this.elementId, messageSubscriptionFilter.elementId)
        && Objects.equals(this.elementInstanceKey, messageSubscriptionFilter.elementInstanceKey)
        && Objects.equals(
            this.messageSubscriptionState, messageSubscriptionFilter.messageSubscriptionState)
        && Objects.equals(this.lastUpdatedDate, messageSubscriptionFilter.lastUpdatedDate)
        && Objects.equals(this.messageName, messageSubscriptionFilter.messageName)
        && Objects.equals(this.correlationKey, messageSubscriptionFilter.correlationKey)
        && Objects.equals(this.tenantId, messageSubscriptionFilter.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        messageSubscriptionKey,
        processDefinitionKey,
        processDefinitionId,
        processInstanceKey,
        elementId,
        elementInstanceKey,
        messageSubscriptionState,
        lastUpdatedDate,
        messageName,
        correlationKey,
        tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageSubscriptionFilter {\n");
    sb.append("    messageSubscriptionKey: ")
        .append(toIndentedString(messageSubscriptionKey))
        .append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    messageSubscriptionState: ")
        .append(toIndentedString(messageSubscriptionState))
        .append("\n");
    sb.append("    lastUpdatedDate: ").append(toIndentedString(lastUpdatedDate)).append("\n");
    sb.append("    messageName: ").append(toIndentedString(messageName)).append("\n");
    sb.append("    correlationKey: ").append(toIndentedString(correlationKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
