/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** The result of the completed job as determined by the worker. */
@JsonPropertyOrder({
  JobResult.JSON_PROPERTY_DENIED,
  JobResult.JSON_PROPERTY_DENIED_REASON,
  JobResult.JSON_PROPERTY_CORRECTIONS,
  JobResult.JSON_PROPERTY_TYPE,
  JobResult.JSON_PROPERTY_ACTIVATE_ELEMENTS,
  JobResult.JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED,
  JobResult.JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
@JsonIgnoreProperties(
    value =
        "type", // ignore manually set type, it will be automatically generated by Jackson during
    // serialization
    allowSetters = true // allows the type to be set during deserialization
    )
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "type",
    visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = JobResultAdHocSubProcess.class, name = "adHocSubProcess"),
  @JsonSubTypes.Type(value = JobResultUserTask.class, name = "userTask"),
})
public class JobResult {
  public static final String JSON_PROPERTY_DENIED = "denied";
  @javax.annotation.Nullable private Boolean denied;

  public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
  @javax.annotation.Nullable private String deniedReason;

  public static final String JSON_PROPERTY_CORRECTIONS = "corrections";
  @javax.annotation.Nullable private JobResultCorrections corrections;

  public static final String JSON_PROPERTY_TYPE = "type";
  // The discriminator does not have Nullability-annotation since it is added during serialization
  // by the @JsonTypeName annotation
  private String type;

  public static final String JSON_PROPERTY_ACTIVATE_ELEMENTS = "activateElements";

  @javax.annotation.Nullable
  private List<JobResultActivateElement> activateElements = new ArrayList<>();

  public static final String JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED =
      "isCompletionConditionFulfilled";
  @javax.annotation.Nullable private Boolean isCompletionConditionFulfilled = false;

  public static final String JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES =
      "isCancelRemainingInstances";
  @javax.annotation.Nullable private Boolean isCancelRemainingInstances = false;

  public JobResult() {}

  public JobResult denied(@javax.annotation.Nullable Boolean denied) {

    this.denied = denied;
    return this;
  }

  /**
   * Indicates whether the worker denies the work, i.e. explicitly doesn&#39;t approve it. For
   * example, a user task listener can deny the completion of a task by setting this flag to true.
   * In this example, the completion of a task is represented by a job that the worker can complete
   * as denied. As a result, the completion request is rejected and the task remains active.
   * Defaults to false.
   *
   * @return denied
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DENIED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDenied() {
    return denied;
  }

  @JsonProperty(value = JSON_PROPERTY_DENIED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDenied(@javax.annotation.Nullable Boolean denied) {
    this.denied = denied;
  }

  public JobResult deniedReason(@javax.annotation.Nullable String deniedReason) {

    this.deniedReason = deniedReason;
    return this;
  }

  /**
   * The reason provided by the user task listener for denying the work.
   *
   * @return deniedReason
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DENIED_REASON, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeniedReason() {
    return deniedReason;
  }

  @JsonProperty(value = JSON_PROPERTY_DENIED_REASON, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeniedReason(@javax.annotation.Nullable String deniedReason) {
    this.deniedReason = deniedReason;
  }

  public JobResult corrections(@javax.annotation.Nullable JobResultCorrections corrections) {

    this.corrections = corrections;
    return this;
  }

  /**
   * Get corrections
   *
   * @return corrections
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CORRECTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobResultCorrections getCorrections() {
    return corrections;
  }

  @JsonProperty(value = JSON_PROPERTY_CORRECTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorrections(@javax.annotation.Nullable JobResultCorrections corrections) {
    this.corrections = corrections;
  }

  public JobResult type(@javax.annotation.Nullable String type) {

    this.type = type;
    return this;
  }

  /**
   * Used to distinguish between different types of job results.
   *
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable String type) {
    this.type = type;
  }

  public JobResult activateElements(
      @javax.annotation.Nullable List<JobResultActivateElement> activateElements) {

    this.activateElements = activateElements;
    return this;
  }

  public JobResult addActivateElementsItem(JobResultActivateElement activateElementsItem) {
    if (this.activateElements == null) {
      this.activateElements = new ArrayList<>();
    }
    this.activateElements.add(activateElementsItem);
    return this;
  }

  /**
   * Indicates which elements need to be activated in the ad-hoc subprocess.
   *
   * @return activateElements
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ACTIVATE_ELEMENTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<JobResultActivateElement> getActivateElements() {
    return activateElements;
  }

  @JsonProperty(value = JSON_PROPERTY_ACTIVATE_ELEMENTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivateElements(
      @javax.annotation.Nullable List<JobResultActivateElement> activateElements) {
    this.activateElements = activateElements;
  }

  public JobResult isCompletionConditionFulfilled(
      @javax.annotation.Nullable Boolean isCompletionConditionFulfilled) {

    this.isCompletionConditionFulfilled = isCompletionConditionFulfilled;
    return this;
  }

  /**
   * Indicates whether the completion condition of the ad-hoc subprocess is fulfilled.
   *
   * @return isCompletionConditionFulfilled
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsCompletionConditionFulfilled() {
    return isCompletionConditionFulfilled;
  }

  @JsonProperty(value = JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCompletionConditionFulfilled(
      @javax.annotation.Nullable Boolean isCompletionConditionFulfilled) {
    this.isCompletionConditionFulfilled = isCompletionConditionFulfilled;
  }

  public JobResult isCancelRemainingInstances(
      @javax.annotation.Nullable Boolean isCancelRemainingInstances) {

    this.isCancelRemainingInstances = isCancelRemainingInstances;
    return this;
  }

  /**
   * Indicates whether the remaining instances of the ad-hoc subprocess should be canceled.
   *
   * @return isCancelRemainingInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsCancelRemainingInstances() {
    return isCancelRemainingInstances;
  }

  @JsonProperty(value = JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancelRemainingInstances(
      @javax.annotation.Nullable Boolean isCancelRemainingInstances) {
    this.isCancelRemainingInstances = isCancelRemainingInstances;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobResult jobResult = (JobResult) o;
    return Objects.equals(this.denied, jobResult.denied)
        && Objects.equals(this.deniedReason, jobResult.deniedReason)
        && Objects.equals(this.corrections, jobResult.corrections)
        && Objects.equals(this.type, jobResult.type)
        && Objects.equals(this.activateElements, jobResult.activateElements)
        && Objects.equals(
            this.isCompletionConditionFulfilled, jobResult.isCompletionConditionFulfilled)
        && Objects.equals(this.isCancelRemainingInstances, jobResult.isCancelRemainingInstances);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        denied,
        deniedReason,
        corrections,
        type,
        activateElements,
        isCompletionConditionFulfilled,
        isCancelRemainingInstances);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobResult {\n");
    sb.append("    denied: ").append(toIndentedString(denied)).append("\n");
    sb.append("    deniedReason: ").append(toIndentedString(deniedReason)).append("\n");
    sb.append("    corrections: ").append(toIndentedString(corrections)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    activateElements: ").append(toIndentedString(activateElements)).append("\n");
    sb.append("    isCompletionConditionFulfilled: ")
        .append(toIndentedString(isCompletionConditionFulfilled))
        .append("\n");
    sb.append("    isCancelRemainingInstances: ")
        .append(toIndentedString(isCancelRemainingInstances))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
