/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** EvaluateDecisionResult */
@JsonPropertyOrder({
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_ID,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_VERSION,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_ID,
  EvaluateDecisionResult.JSON_PROPERTY_OUTPUT,
  EvaluateDecisionResult.JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID,
  EvaluateDecisionResult.JSON_PROPERTY_FAILURE_MESSAGE,
  EvaluateDecisionResult.JSON_PROPERTY_TENANT_ID,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_KEY,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_INSTANCE_KEY,
  EvaluateDecisionResult.JSON_PROPERTY_DECISION_EVALUATION_KEY,
  EvaluateDecisionResult.JSON_PROPERTY_EVALUATED_DECISIONS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class EvaluateDecisionResult {
  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  @javax.annotation.Nonnull private String decisionDefinitionId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  @javax.annotation.Nonnull private String decisionDefinitionName;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_VERSION =
      "decisionDefinitionVersion";
  @javax.annotation.Nonnull private Integer decisionDefinitionVersion;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_ID = "decisionRequirementsId";
  @javax.annotation.Nonnull private String decisionRequirementsId;

  public static final String JSON_PROPERTY_OUTPUT = "output";
  @javax.annotation.Nonnull private String output;

  public static final String JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID =
      "failedDecisionDefinitionId";
  @javax.annotation.Nonnull private String failedDecisionDefinitionId;

  public static final String JSON_PROPERTY_FAILURE_MESSAGE = "failureMessage";
  @javax.annotation.Nonnull private String failureMessage;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nonnull private String tenantId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  @javax.annotation.Nonnull private String decisionDefinitionKey;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_KEY = "decisionRequirementsKey";
  @javax.annotation.Nonnull private String decisionRequirementsKey;

  public static final String JSON_PROPERTY_DECISION_INSTANCE_KEY = "decisionInstanceKey";
  @javax.annotation.Nullable private String decisionInstanceKey;

  public static final String JSON_PROPERTY_DECISION_EVALUATION_KEY = "decisionEvaluationKey";
  @javax.annotation.Nonnull private String decisionEvaluationKey;

  public static final String JSON_PROPERTY_EVALUATED_DECISIONS = "evaluatedDecisions";

  @javax.annotation.Nonnull
  private List<EvaluatedDecisionResult> evaluatedDecisions = new ArrayList<>();

  public EvaluateDecisionResult() {}

  public EvaluateDecisionResult decisionDefinitionId(
      @javax.annotation.Nonnull String decisionDefinitionId) {

    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which was evaluated.
   *
   * @return decisionDefinitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionDefinitionId(@javax.annotation.Nonnull String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public EvaluateDecisionResult decisionDefinitionName(
      @javax.annotation.Nonnull String decisionDefinitionName) {

    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the decision which was evaluated.
   *
   * @return decisionDefinitionName
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionDefinitionName(@javax.annotation.Nonnull String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public EvaluateDecisionResult decisionDefinitionVersion(
      @javax.annotation.Nonnull Integer decisionDefinitionVersion) {

    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision which was evaluated.
   *
   * @return decisionDefinitionVersion
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionDefinitionVersion(
      @javax.annotation.Nonnull Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public EvaluateDecisionResult decisionRequirementsId(
      @javax.annotation.Nonnull String decisionRequirementsId) {

    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The ID of the decision requirements graph that the decision which was evaluated is part of.
   *
   * @return decisionRequirementsId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionRequirementsId(@javax.annotation.Nonnull String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public EvaluateDecisionResult output(@javax.annotation.Nonnull String output) {

    this.output = output;
    return this;
  }

  /**
   * JSON document that will instantiate the result of the decision which was evaluated.
   *
   * @return output
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_OUTPUT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getOutput() {
    return output;
  }

  @JsonProperty(value = JSON_PROPERTY_OUTPUT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOutput(@javax.annotation.Nonnull String output) {
    this.output = output;
  }

  public EvaluateDecisionResult failedDecisionDefinitionId(
      @javax.annotation.Nonnull String failedDecisionDefinitionId) {

    this.failedDecisionDefinitionId = failedDecisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which failed during evaluation.
   *
   * @return failedDecisionDefinitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getFailedDecisionDefinitionId() {
    return failedDecisionDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFailedDecisionDefinitionId(
      @javax.annotation.Nonnull String failedDecisionDefinitionId) {
    this.failedDecisionDefinitionId = failedDecisionDefinitionId;
  }

  public EvaluateDecisionResult failureMessage(@javax.annotation.Nonnull String failureMessage) {

    this.failureMessage = failureMessage;
    return this;
  }

  /**
   * Message describing why the decision which was evaluated failed.
   *
   * @return failureMessage
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_FAILURE_MESSAGE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getFailureMessage() {
    return failureMessage;
  }

  @JsonProperty(value = JSON_PROPERTY_FAILURE_MESSAGE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFailureMessage(@javax.annotation.Nonnull String failureMessage) {
    this.failureMessage = failureMessage;
  }

  public EvaluateDecisionResult tenantId(@javax.annotation.Nonnull String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the evaluated decision.
   *
   * @return tenantId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTenantId(@javax.annotation.Nonnull String tenantId) {
    this.tenantId = tenantId;
  }

  public EvaluateDecisionResult decisionDefinitionKey(
      @javax.annotation.Nonnull String decisionDefinitionKey) {

    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the decision which was evaluated.
   *
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionDefinitionKey(@javax.annotation.Nonnull String decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public EvaluateDecisionResult decisionRequirementsKey(
      @javax.annotation.Nonnull String decisionRequirementsKey) {

    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The unique key identifying the decision requirements graph that the decision which was
   * evaluated is part of.
   *
   * @return decisionRequirementsKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionRequirementsKey(@javax.annotation.Nonnull String decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public EvaluateDecisionResult decisionInstanceKey(
      @javax.annotation.Nullable String decisionInstanceKey) {

    this.decisionInstanceKey = decisionInstanceKey;
    return this;
  }

  /**
   * Deprecated, please refer to &#x60;decisionEvaluationKey&#x60;.
   *
   * @return decisionInstanceKey
   * @deprecated
   */
  @Deprecated
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DECISION_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionInstanceKey() {
    return decisionInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionInstanceKey(@javax.annotation.Nullable String decisionInstanceKey) {
    this.decisionInstanceKey = decisionInstanceKey;
  }

  public EvaluateDecisionResult decisionEvaluationKey(
      @javax.annotation.Nonnull String decisionEvaluationKey) {

    this.decisionEvaluationKey = decisionEvaluationKey;
    return this;
  }

  /**
   * The unique key identifying this decision evaluation.
   *
   * @return decisionEvaluationKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DECISION_EVALUATION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDecisionEvaluationKey() {
    return decisionEvaluationKey;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_EVALUATION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDecisionEvaluationKey(@javax.annotation.Nonnull String decisionEvaluationKey) {
    this.decisionEvaluationKey = decisionEvaluationKey;
  }

  public EvaluateDecisionResult evaluatedDecisions(
      @javax.annotation.Nonnull List<EvaluatedDecisionResult> evaluatedDecisions) {

    this.evaluatedDecisions = evaluatedDecisions;
    return this;
  }

  public EvaluateDecisionResult addEvaluatedDecisionsItem(
      EvaluatedDecisionResult evaluatedDecisionsItem) {
    if (this.evaluatedDecisions == null) {
      this.evaluatedDecisions = new ArrayList<>();
    }
    this.evaluatedDecisions.add(evaluatedDecisionsItem);
    return this;
  }

  /**
   * Decisions that were evaluated within the requested decision evaluation.
   *
   * @return evaluatedDecisions
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_EVALUATED_DECISIONS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<EvaluatedDecisionResult> getEvaluatedDecisions() {
    return evaluatedDecisions;
  }

  @JsonProperty(value = JSON_PROPERTY_EVALUATED_DECISIONS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEvaluatedDecisions(
      @javax.annotation.Nonnull List<EvaluatedDecisionResult> evaluatedDecisions) {
    this.evaluatedDecisions = evaluatedDecisions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluateDecisionResult evaluateDecisionResult = (EvaluateDecisionResult) o;
    return Objects.equals(this.decisionDefinitionId, evaluateDecisionResult.decisionDefinitionId)
        && Objects.equals(
            this.decisionDefinitionName, evaluateDecisionResult.decisionDefinitionName)
        && Objects.equals(
            this.decisionDefinitionVersion, evaluateDecisionResult.decisionDefinitionVersion)
        && Objects.equals(
            this.decisionRequirementsId, evaluateDecisionResult.decisionRequirementsId)
        && Objects.equals(this.output, evaluateDecisionResult.output)
        && Objects.equals(
            this.failedDecisionDefinitionId, evaluateDecisionResult.failedDecisionDefinitionId)
        && Objects.equals(this.failureMessage, evaluateDecisionResult.failureMessage)
        && Objects.equals(this.tenantId, evaluateDecisionResult.tenantId)
        && Objects.equals(this.decisionDefinitionKey, evaluateDecisionResult.decisionDefinitionKey)
        && Objects.equals(
            this.decisionRequirementsKey, evaluateDecisionResult.decisionRequirementsKey)
        && Objects.equals(this.decisionInstanceKey, evaluateDecisionResult.decisionInstanceKey)
        && Objects.equals(this.decisionEvaluationKey, evaluateDecisionResult.decisionEvaluationKey)
        && Objects.equals(this.evaluatedDecisions, evaluateDecisionResult.evaluatedDecisions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        decisionDefinitionId,
        decisionDefinitionName,
        decisionDefinitionVersion,
        decisionRequirementsId,
        output,
        failedDecisionDefinitionId,
        failureMessage,
        tenantId,
        decisionDefinitionKey,
        decisionRequirementsKey,
        decisionInstanceKey,
        decisionEvaluationKey,
        evaluatedDecisions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluateDecisionResult {\n");
    sb.append("    decisionDefinitionId: ")
        .append(toIndentedString(decisionDefinitionId))
        .append("\n");
    sb.append("    decisionDefinitionName: ")
        .append(toIndentedString(decisionDefinitionName))
        .append("\n");
    sb.append("    decisionDefinitionVersion: ")
        .append(toIndentedString(decisionDefinitionVersion))
        .append("\n");
    sb.append("    decisionRequirementsId: ")
        .append(toIndentedString(decisionRequirementsId))
        .append("\n");
    sb.append("    output: ").append(toIndentedString(output)).append("\n");
    sb.append("    failedDecisionDefinitionId: ")
        .append(toIndentedString(failedDecisionDefinitionId))
        .append("\n");
    sb.append("    failureMessage: ").append(toIndentedString(failureMessage)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionDefinitionKey: ")
        .append(toIndentedString(decisionDefinitionKey))
        .append("\n");
    sb.append("    decisionRequirementsKey: ")
        .append(toIndentedString(decisionRequirementsKey))
        .append("\n");
    sb.append("    decisionInstanceKey: ")
        .append(toIndentedString(decisionInstanceKey))
        .append("\n");
    sb.append("    decisionEvaluationKey: ")
        .append(toIndentedString(decisionEvaluationKey))
        .append("\n");
    sb.append("    evaluatedDecisions: ").append(toIndentedString(evaluatedDecisions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
