/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

/** ElementInstanceResult */
@JsonPropertyOrder({
  ElementInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ElementInstanceResult.JSON_PROPERTY_START_DATE,
  ElementInstanceResult.JSON_PROPERTY_END_DATE,
  ElementInstanceResult.JSON_PROPERTY_ELEMENT_ID,
  ElementInstanceResult.JSON_PROPERTY_ELEMENT_NAME,
  ElementInstanceResult.JSON_PROPERTY_TYPE,
  ElementInstanceResult.JSON_PROPERTY_STATE,
  ElementInstanceResult.JSON_PROPERTY_HAS_INCIDENT,
  ElementInstanceResult.JSON_PROPERTY_TENANT_ID,
  ElementInstanceResult.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  ElementInstanceResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ElementInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ElementInstanceResult.JSON_PROPERTY_INCIDENT_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class ElementInstanceResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nonnull private String processDefinitionId;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nonnull private String startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable private String endDate;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nonnull private String elementId;

  public static final String JSON_PROPERTY_ELEMENT_NAME = "elementName";
  @javax.annotation.Nonnull private String elementName;

  /** Type of element as defined set of values. */
  public enum TypeEnum {
    UNSPECIFIED(String.valueOf("UNSPECIFIED")),

    PROCESS(String.valueOf("PROCESS")),

    SUB_PROCESS(String.valueOf("SUB_PROCESS")),

    EVENT_SUB_PROCESS(String.valueOf("EVENT_SUB_PROCESS")),

    AD_HOC_SUB_PROCESS(String.valueOf("AD_HOC_SUB_PROCESS")),

    AD_HOC_SUB_PROCESS_INNER_INSTANCE(String.valueOf("AD_HOC_SUB_PROCESS_INNER_INSTANCE")),

    START_EVENT(String.valueOf("START_EVENT")),

    INTERMEDIATE_CATCH_EVENT(String.valueOf("INTERMEDIATE_CATCH_EVENT")),

    INTERMEDIATE_THROW_EVENT(String.valueOf("INTERMEDIATE_THROW_EVENT")),

    BOUNDARY_EVENT(String.valueOf("BOUNDARY_EVENT")),

    END_EVENT(String.valueOf("END_EVENT")),

    SERVICE_TASK(String.valueOf("SERVICE_TASK")),

    RECEIVE_TASK(String.valueOf("RECEIVE_TASK")),

    USER_TASK(String.valueOf("USER_TASK")),

    MANUAL_TASK(String.valueOf("MANUAL_TASK")),

    TASK(String.valueOf("TASK")),

    EXCLUSIVE_GATEWAY(String.valueOf("EXCLUSIVE_GATEWAY")),

    INCLUSIVE_GATEWAY(String.valueOf("INCLUSIVE_GATEWAY")),

    PARALLEL_GATEWAY(String.valueOf("PARALLEL_GATEWAY")),

    EVENT_BASED_GATEWAY(String.valueOf("EVENT_BASED_GATEWAY")),

    SEQUENCE_FLOW(String.valueOf("SEQUENCE_FLOW")),

    MULTI_INSTANCE_BODY(String.valueOf("MULTI_INSTANCE_BODY")),

    CALL_ACTIVITY(String.valueOf("CALL_ACTIVITY")),

    BUSINESS_RULE_TASK(String.valueOf("BUSINESS_RULE_TASK")),

    SCRIPT_TASK(String.valueOf("SCRIPT_TASK")),

    SEND_TASK(String.valueOf("SEND_TASK")),

    UNKNOWN(String.valueOf("UNKNOWN")),

    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nonnull private TypeEnum type;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nonnull private ElementInstanceStateEnum state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nonnull private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nonnull private String tenantId;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nonnull private String elementInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nonnull private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nonnull private String processDefinitionKey;

  public static final String JSON_PROPERTY_INCIDENT_KEY = "incidentKey";
  @javax.annotation.Nullable private String incidentKey;

  public ElementInstanceResult() {}

  public ElementInstanceResult processDefinitionId(
      @javax.annotation.Nonnull String processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated to this element instance.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionId(@javax.annotation.Nonnull String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ElementInstanceResult startDate(@javax.annotation.Nonnull String startDate) {

    this.startDate = startDate;
    return this;
  }

  /**
   * Date when element instance started.
   *
   * @return startDate
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_START_DATE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getStartDate() {
    return startDate;
  }

  @JsonProperty(value = JSON_PROPERTY_START_DATE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(@javax.annotation.Nonnull String startDate) {
    this.startDate = startDate;
  }

  public ElementInstanceResult endDate(@javax.annotation.Nullable String endDate) {

    this.endDate = endDate;
    return this;
  }

  /**
   * Date when element instance finished.
   *
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_END_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEndDate() {
    return endDate;
  }

  @JsonProperty(value = JSON_PROPERTY_END_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable String endDate) {
    this.endDate = endDate;
  }

  public ElementInstanceResult elementId(@javax.annotation.Nonnull String elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID for this element instance.
   *
   * @return elementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementId(@javax.annotation.Nonnull String elementId) {
    this.elementId = elementId;
  }

  public ElementInstanceResult elementName(@javax.annotation.Nonnull String elementName) {

    this.elementName = elementName;
    return this;
  }

  /**
   * The element name for this element instance.
   *
   * @return elementName
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getElementName() {
    return elementName;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementName(@javax.annotation.Nonnull String elementName) {
    this.elementName = elementName;
  }

  public ElementInstanceResult type(@javax.annotation.Nonnull TypeEnum type) {

    this.type = type;
    return this;
  }

  /**
   * Type of element as defined set of values.
   *
   * @return type
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty(value = JSON_PROPERTY_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@javax.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public ElementInstanceResult state(@javax.annotation.Nonnull ElementInstanceStateEnum state) {

    this.state = state;
    return this;
  }

  /**
   * State of element instance as defined set of values.
   *
   * @return state
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_STATE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public ElementInstanceStateEnum getState() {
    return state;
  }

  @JsonProperty(value = JSON_PROPERTY_STATE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setState(@javax.annotation.Nonnull ElementInstanceStateEnum state) {
    this.state = state;
  }

  public ElementInstanceResult hasIncident(@javax.annotation.Nonnull Boolean hasIncident) {

    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Shows whether this element instance has an incident. If true also an incidentKey is provided.
   *
   * @return hasIncident
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_HAS_INCIDENT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getHasIncident() {
    return hasIncident;
  }

  @JsonProperty(value = JSON_PROPERTY_HAS_INCIDENT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHasIncident(@javax.annotation.Nonnull Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public ElementInstanceResult tenantId(@javax.annotation.Nonnull String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the incident.
   *
   * @return tenantId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTenantId(@javax.annotation.Nonnull String tenantId) {
    this.tenantId = tenantId;
  }

  public ElementInstanceResult elementInstanceKey(
      @javax.annotation.Nonnull String elementInstanceKey) {

    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this element instance.
   *
   * @return elementInstanceKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getElementInstanceKey() {
    return elementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementInstanceKey(@javax.annotation.Nonnull String elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ElementInstanceResult processInstanceKey(
      @javax.annotation.Nonnull String processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this element instance.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessInstanceKey(@javax.annotation.Nonnull String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ElementInstanceResult processDefinitionKey(
      @javax.annotation.Nonnull String processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this element instance.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionKey(@javax.annotation.Nonnull String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ElementInstanceResult incidentKey(@javax.annotation.Nullable String incidentKey) {

    this.incidentKey = incidentKey;
    return this;
  }

  /**
   * Incident key associated with this element instance.
   *
   * @return incidentKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_INCIDENT_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIncidentKey() {
    return incidentKey;
  }

  @JsonProperty(value = JSON_PROPERTY_INCIDENT_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentKey(@javax.annotation.Nullable String incidentKey) {
    this.incidentKey = incidentKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ElementInstanceResult elementInstanceResult = (ElementInstanceResult) o;
    return Objects.equals(this.processDefinitionId, elementInstanceResult.processDefinitionId)
        && Objects.equals(this.startDate, elementInstanceResult.startDate)
        && Objects.equals(this.endDate, elementInstanceResult.endDate)
        && Objects.equals(this.elementId, elementInstanceResult.elementId)
        && Objects.equals(this.elementName, elementInstanceResult.elementName)
        && Objects.equals(this.type, elementInstanceResult.type)
        && Objects.equals(this.state, elementInstanceResult.state)
        && Objects.equals(this.hasIncident, elementInstanceResult.hasIncident)
        && Objects.equals(this.tenantId, elementInstanceResult.tenantId)
        && Objects.equals(this.elementInstanceKey, elementInstanceResult.elementInstanceKey)
        && Objects.equals(this.processInstanceKey, elementInstanceResult.processInstanceKey)
        && Objects.equals(this.processDefinitionKey, elementInstanceResult.processDefinitionKey)
        && Objects.equals(this.incidentKey, elementInstanceResult.incidentKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        processDefinitionId,
        startDate,
        endDate,
        elementId,
        elementName,
        type,
        state,
        hasIncident,
        tenantId,
        elementInstanceKey,
        processInstanceKey,
        processDefinitionKey,
        incidentKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ElementInstanceResult {\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementName: ").append(toIndentedString(elementName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    incidentKey: ").append(toIndentedString(incidentKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
