/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** A deployed decision. */
@JsonPropertyOrder({
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_ID,
  DeploymentDecisionResult.JSON_PROPERTY_VERSION,
  DeploymentDecisionResult.JSON_PROPERTY_NAME,
  DeploymentDecisionResult.JSON_PROPERTY_TENANT_ID,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_ID,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class DeploymentDecisionResult {
  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  @javax.annotation.Nullable private String decisionDefinitionId;

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nullable private Integer version;

  public static final String JSON_PROPERTY_NAME = "name";
  @javax.annotation.Nullable private String name;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private String tenantId;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_ID = "decisionRequirementsId";
  @javax.annotation.Nullable private String decisionRequirementsId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  @javax.annotation.Nullable private String decisionDefinitionKey;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_KEY = "decisionRequirementsKey";
  @javax.annotation.Nullable private String decisionRequirementsKey;

  public DeploymentDecisionResult() {}

  public DeploymentDecisionResult decisionDefinitionId(
      @javax.annotation.Nullable String decisionDefinitionId) {

    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The dmn decision ID, as parsed during deployment, together with the version forms a unique
   * identifier for a specific decision.
   *
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(@javax.annotation.Nullable String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DeploymentDecisionResult version(@javax.annotation.Nullable Integer version) {

    this.version = version;
    return this;
  }

  /**
   * The assigned decision version.
   *
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_VERSION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getVersion() {
    return version;
  }

  @JsonProperty(value = JSON_PROPERTY_VERSION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@javax.annotation.Nullable Integer version) {
    this.version = version;
  }

  public DeploymentDecisionResult name(@javax.annotation.Nullable String name) {

    this.name = name;
    return this;
  }

  /**
   * The DMN name of the decision, as parsed during deployment.
   *
   * @return name
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  @JsonProperty(value = JSON_PROPERTY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@javax.annotation.Nullable String name) {
    this.name = name;
  }

  public DeploymentDecisionResult tenantId(@javax.annotation.Nullable String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed decision.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public DeploymentDecisionResult decisionRequirementsId(
      @javax.annotation.Nullable String decisionRequirementsId) {

    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The dmn ID of the decision requirements graph that this decision is part of, as parsed during
   * deployment.
   *
   * @return decisionRequirementsId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsId(@javax.annotation.Nullable String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DeploymentDecisionResult decisionDefinitionKey(
      @javax.annotation.Nullable String decisionDefinitionKey) {

    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The assigned decision key, which acts as a unique identifier for this decision.
   *
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionKey(@javax.annotation.Nullable String decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DeploymentDecisionResult decisionRequirementsKey(
      @javax.annotation.Nullable String decisionRequirementsKey) {

    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned key of the decision requirements graph that this decision is part of.
   *
   * @return decisionRequirementsKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_REQUIREMENTS_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsKey(
      @javax.annotation.Nullable String decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentDecisionResult deploymentDecisionResult = (DeploymentDecisionResult) o;
    return Objects.equals(this.decisionDefinitionId, deploymentDecisionResult.decisionDefinitionId)
        && Objects.equals(this.version, deploymentDecisionResult.version)
        && Objects.equals(this.name, deploymentDecisionResult.name)
        && Objects.equals(this.tenantId, deploymentDecisionResult.tenantId)
        && Objects.equals(
            this.decisionRequirementsId, deploymentDecisionResult.decisionRequirementsId)
        && Objects.equals(
            this.decisionDefinitionKey, deploymentDecisionResult.decisionDefinitionKey)
        && Objects.equals(
            this.decisionRequirementsKey, deploymentDecisionResult.decisionRequirementsKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        decisionDefinitionId,
        version,
        name,
        tenantId,
        decisionRequirementsId,
        decisionDefinitionKey,
        decisionRequirementsKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentDecisionResult {\n");
    sb.append("    decisionDefinitionId: ")
        .append(toIndentedString(decisionDefinitionId))
        .append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsId: ")
        .append(toIndentedString(decisionRequirementsId))
        .append("\n");
    sb.append("    decisionDefinitionKey: ")
        .append(toIndentedString(decisionDefinitionKey))
        .append("\n");
    sb.append("    decisionRequirementsKey: ")
        .append(toIndentedString(decisionRequirementsKey))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
