/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** CamundaUserResult */
@JsonPropertyOrder({
  CamundaUserResult.JSON_PROPERTY_USERNAME,
  CamundaUserResult.JSON_PROPERTY_DISPLAY_NAME,
  CamundaUserResult.JSON_PROPERTY_EMAIL,
  CamundaUserResult.JSON_PROPERTY_AUTHORIZED_COMPONENTS,
  CamundaUserResult.JSON_PROPERTY_TENANTS,
  CamundaUserResult.JSON_PROPERTY_GROUPS,
  CamundaUserResult.JSON_PROPERTY_ROLES,
  CamundaUserResult.JSON_PROPERTY_SALES_PLAN_TYPE,
  CamundaUserResult.JSON_PROPERTY_C8_LINKS,
  CamundaUserResult.JSON_PROPERTY_CAN_LOGOUT
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class CamundaUserResult {
  public static final String JSON_PROPERTY_USERNAME = "username";
  @javax.annotation.Nullable private String username;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  @javax.annotation.Nullable private String displayName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  @javax.annotation.Nullable private String email;

  public static final String JSON_PROPERTY_AUTHORIZED_COMPONENTS = "authorizedComponents";
  @javax.annotation.Nullable private List<String> authorizedComponents = new ArrayList<>();

  public static final String JSON_PROPERTY_TENANTS = "tenants";
  @javax.annotation.Nonnull private List<TenantResult> tenants = new ArrayList<>();

  public static final String JSON_PROPERTY_GROUPS = "groups";
  @javax.annotation.Nonnull private List<String> groups = new ArrayList<>();

  public static final String JSON_PROPERTY_ROLES = "roles";
  @javax.annotation.Nonnull private List<String> roles = new ArrayList<>();

  public static final String JSON_PROPERTY_SALES_PLAN_TYPE = "salesPlanType";
  @javax.annotation.Nonnull private String salesPlanType;

  public static final String JSON_PROPERTY_C8_LINKS = "c8Links";
  @javax.annotation.Nonnull private Map<String, String> c8Links = new HashMap<>();

  public static final String JSON_PROPERTY_CAN_LOGOUT = "canLogout";
  @javax.annotation.Nonnull private Boolean canLogout;

  public CamundaUserResult() {}

  public CamundaUserResult username(@javax.annotation.Nullable String username) {

    this.username = username;
    return this;
  }

  /**
   * The username of the user.
   *
   * @return username
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_USERNAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }

  @JsonProperty(value = JSON_PROPERTY_USERNAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(@javax.annotation.Nullable String username) {
    this.username = username;
  }

  public CamundaUserResult displayName(@javax.annotation.Nullable String displayName) {

    this.displayName = displayName;
    return this;
  }

  /**
   * The display name of the user.
   *
   * @return displayName
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DISPLAY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDisplayName() {
    return displayName;
  }

  @JsonProperty(value = JSON_PROPERTY_DISPLAY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(@javax.annotation.Nullable String displayName) {
    this.displayName = displayName;
  }

  public CamundaUserResult email(@javax.annotation.Nullable String email) {

    this.email = email;
    return this;
  }

  /**
   * The email of the user.
   *
   * @return email
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_EMAIL, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  @JsonProperty(value = JSON_PROPERTY_EMAIL, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(@javax.annotation.Nullable String email) {
    this.email = email;
  }

  public CamundaUserResult authorizedComponents(
      @javax.annotation.Nullable List<String> authorizedComponents) {

    this.authorizedComponents = authorizedComponents;
    return this;
  }

  public CamundaUserResult addAuthorizedComponentsItem(String authorizedComponentsItem) {
    if (this.authorizedComponents == null) {
      this.authorizedComponents = new ArrayList<>();
    }
    this.authorizedComponents.add(authorizedComponentsItem);
    return this;
  }

  /**
   * The web components the user is authorized to use.
   *
   * @return authorizedComponents
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_AUTHORIZED_COMPONENTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAuthorizedComponents() {
    return authorizedComponents;
  }

  @JsonProperty(value = JSON_PROPERTY_AUTHORIZED_COMPONENTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorizedComponents(
      @javax.annotation.Nullable List<String> authorizedComponents) {
    this.authorizedComponents = authorizedComponents;
  }

  public CamundaUserResult tenants(@javax.annotation.Nonnull List<TenantResult> tenants) {

    this.tenants = tenants;
    return this;
  }

  public CamundaUserResult addTenantsItem(TenantResult tenantsItem) {
    if (this.tenants == null) {
      this.tenants = new ArrayList<>();
    }
    this.tenants.add(tenantsItem);
    return this;
  }

  /**
   * The tenants the user is a member of.
   *
   * @return tenants
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TENANTS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<TenantResult> getTenants() {
    return tenants;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANTS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTenants(@javax.annotation.Nonnull List<TenantResult> tenants) {
    this.tenants = tenants;
  }

  public CamundaUserResult groups(@javax.annotation.Nonnull List<String> groups) {

    this.groups = groups;
    return this;
  }

  public CamundaUserResult addGroupsItem(String groupsItem) {
    if (this.groups == null) {
      this.groups = new ArrayList<>();
    }
    this.groups.add(groupsItem);
    return this;
  }

  /**
   * The groups assigned to the user.
   *
   * @return groups
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_GROUPS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<String> getGroups() {
    return groups;
  }

  @JsonProperty(value = JSON_PROPERTY_GROUPS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroups(@javax.annotation.Nonnull List<String> groups) {
    this.groups = groups;
  }

  public CamundaUserResult roles(@javax.annotation.Nonnull List<String> roles) {

    this.roles = roles;
    return this;
  }

  public CamundaUserResult addRolesItem(String rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * The roles assigned to the user.
   *
   * @return roles
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ROLES, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<String> getRoles() {
    return roles;
  }

  @JsonProperty(value = JSON_PROPERTY_ROLES, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoles(@javax.annotation.Nonnull List<String> roles) {
    this.roles = roles;
  }

  public CamundaUserResult salesPlanType(@javax.annotation.Nonnull String salesPlanType) {

    this.salesPlanType = salesPlanType;
    return this;
  }

  /**
   * The plan of the user.
   *
   * @return salesPlanType
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_SALES_PLAN_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getSalesPlanType() {
    return salesPlanType;
  }

  @JsonProperty(value = JSON_PROPERTY_SALES_PLAN_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesPlanType(@javax.annotation.Nonnull String salesPlanType) {
    this.salesPlanType = salesPlanType;
  }

  public CamundaUserResult c8Links(@javax.annotation.Nonnull Map<String, String> c8Links) {

    this.c8Links = c8Links;
    return this;
  }

  public CamundaUserResult putC8LinksItem(String key, String c8LinksItem) {
    this.c8Links.put(key, c8LinksItem);
    return this;
  }

  /**
   * The links to the components in the C8 stack.
   *
   * @return c8Links
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_C8_LINKS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Map<String, String> getC8Links() {
    return c8Links;
  }

  @JsonProperty(value = JSON_PROPERTY_C8_LINKS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setC8Links(@javax.annotation.Nonnull Map<String, String> c8Links) {
    this.c8Links = c8Links;
  }

  public CamundaUserResult canLogout(@javax.annotation.Nonnull Boolean canLogout) {

    this.canLogout = canLogout;
    return this;
  }

  /**
   * Flag for understanding if the user is able to perform logout.
   *
   * @return canLogout
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_CAN_LOGOUT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getCanLogout() {
    return canLogout;
  }

  @JsonProperty(value = JSON_PROPERTY_CAN_LOGOUT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCanLogout(@javax.annotation.Nonnull Boolean canLogout) {
    this.canLogout = canLogout;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CamundaUserResult camundaUserResult = (CamundaUserResult) o;
    return Objects.equals(this.username, camundaUserResult.username)
        && Objects.equals(this.displayName, camundaUserResult.displayName)
        && Objects.equals(this.email, camundaUserResult.email)
        && Objects.equals(this.authorizedComponents, camundaUserResult.authorizedComponents)
        && Objects.equals(this.tenants, camundaUserResult.tenants)
        && Objects.equals(this.groups, camundaUserResult.groups)
        && Objects.equals(this.roles, camundaUserResult.roles)
        && Objects.equals(this.salesPlanType, camundaUserResult.salesPlanType)
        && Objects.equals(this.c8Links, camundaUserResult.c8Links)
        && Objects.equals(this.canLogout, camundaUserResult.canLogout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        username,
        displayName,
        email,
        authorizedComponents,
        tenants,
        groups,
        roles,
        salesPlanType,
        c8Links,
        canLogout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CamundaUserResult {\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    authorizedComponents: ")
        .append(toIndentedString(authorizedComponents))
        .append("\n");
    sb.append("    tenants: ").append(toIndentedString(tenants)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    salesPlanType: ").append(toIndentedString(salesPlanType)).append("\n");
    sb.append("    c8Links: ").append(toIndentedString(c8Links)).append("\n");
    sb.append("    canLogout: ").append(toIndentedString(canLogout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
