/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/** Base process instance search filter. */
@JsonPropertyOrder({
  BaseProcessInstanceFilterFields.JSON_PROPERTY_START_DATE,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_END_DATE,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_STATE,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_HAS_INCIDENT,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_TENANT_ID,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_VARIABLES,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_BATCH_OPERATION_ID,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_ERROR_MESSAGE,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_HAS_RETRIES_LEFT,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_ELEMENT_INSTANCE_STATE,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_ELEMENT_ID,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE,
  BaseProcessInstanceFilterFields.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class BaseProcessInstanceFilterFields {
  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable private DateTimeFilterProperty startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable private DateTimeFilterProperty endDate;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable private ProcessInstanceStateFilterProperty state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nullable private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";

  @javax.annotation.Nullable
  private List<VariableValueFilterProperty> variables = new ArrayList<>();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable private ProcessInstanceKeyFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY = "parentProcessInstanceKey";
  @javax.annotation.Nullable private ProcessInstanceKeyFilterProperty parentProcessInstanceKey;

  public static final String JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY = "parentElementInstanceKey";
  @javax.annotation.Nullable private ElementInstanceKeyFilterProperty parentElementInstanceKey;

  public static final String JSON_PROPERTY_BATCH_OPERATION_ID = "batchOperationId";
  @javax.annotation.Nullable private StringFilterProperty batchOperationId;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable private StringFilterProperty errorMessage;

  public static final String JSON_PROPERTY_HAS_RETRIES_LEFT = "hasRetriesLeft";
  @javax.annotation.Nullable private Boolean hasRetriesLeft;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_STATE = "elementInstanceState";
  @javax.annotation.Nullable private ElementInstanceStateFilterProperty elementInstanceState;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable private StringFilterProperty elementId;

  public static final String JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT =
      "hasElementInstanceIncident";
  @javax.annotation.Nullable private Boolean hasElementInstanceIncident;

  public static final String JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE = "incidentErrorHashCode";
  @javax.annotation.Nullable private IntegerFilterProperty incidentErrorHashCode;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable private Set<String> tags = new LinkedHashSet<>();

  public BaseProcessInstanceFilterFields() {}

  public BaseProcessInstanceFilterFields startDate(
      @javax.annotation.Nullable DateTimeFilterProperty startDate) {

    this.startDate = startDate;
    return this;
  }

  /**
   * The start date.
   *
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_START_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getStartDate() {
    return startDate;
  }

  @JsonProperty(value = JSON_PROPERTY_START_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable DateTimeFilterProperty startDate) {
    this.startDate = startDate;
  }

  public BaseProcessInstanceFilterFields endDate(
      @javax.annotation.Nullable DateTimeFilterProperty endDate) {

    this.endDate = endDate;
    return this;
  }

  /**
   * The end date.
   *
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_END_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getEndDate() {
    return endDate;
  }

  @JsonProperty(value = JSON_PROPERTY_END_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable DateTimeFilterProperty endDate) {
    this.endDate = endDate;
  }

  public BaseProcessInstanceFilterFields state(
      @javax.annotation.Nullable ProcessInstanceStateFilterProperty state) {

    this.state = state;
    return this;
  }

  /**
   * The process instance state.
   *
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessInstanceStateFilterProperty getState() {
    return state;
  }

  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable ProcessInstanceStateFilterProperty state) {
    this.state = state;
  }

  public BaseProcessInstanceFilterFields hasIncident(
      @javax.annotation.Nullable Boolean hasIncident) {

    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Whether this process instance has a related incident or not.
   *
   * @return hasIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_HAS_INCIDENT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasIncident() {
    return hasIncident;
  }

  @JsonProperty(value = JSON_PROPERTY_HAS_INCIDENT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public BaseProcessInstanceFilterFields tenantId(
      @javax.annotation.Nullable StringFilterProperty tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public BaseProcessInstanceFilterFields variables(
      @javax.annotation.Nullable List<VariableValueFilterProperty> variables) {

    this.variables = variables;
    return this;
  }

  public BaseProcessInstanceFilterFields addVariablesItem(
      VariableValueFilterProperty variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<>();
    }
    this.variables.add(variablesItem);
    return this;
  }

  /**
   * The process instance variables.
   *
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<VariableValueFilterProperty> getVariables() {
    return variables;
  }

  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable List<VariableValueFilterProperty> variables) {
    this.variables = variables;
  }

  public BaseProcessInstanceFilterFields processInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of this process instance.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessInstanceKeyFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public BaseProcessInstanceFilterFields parentProcessInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty parentProcessInstanceKey) {

    this.parentProcessInstanceKey = parentProcessInstanceKey;
    return this;
  }

  /**
   * The parent process instance key.
   *
   * @return parentProcessInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessInstanceKeyFilterProperty getParentProcessInstanceKey() {
    return parentProcessInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentProcessInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty parentProcessInstanceKey) {
    this.parentProcessInstanceKey = parentProcessInstanceKey;
  }

  public BaseProcessInstanceFilterFields parentElementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty parentElementInstanceKey) {

    this.parentElementInstanceKey = parentElementInstanceKey;
    return this;
  }

  /**
   * The parent element instance key.
   *
   * @return parentElementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ElementInstanceKeyFilterProperty getParentElementInstanceKey() {
    return parentElementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentElementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty parentElementInstanceKey) {
    this.parentElementInstanceKey = parentElementInstanceKey;
  }

  public BaseProcessInstanceFilterFields batchOperationId(
      @javax.annotation.Nullable StringFilterProperty batchOperationId) {

    this.batchOperationId = batchOperationId;
    return this;
  }

  /**
   * The batch operation id.
   *
   * @return batchOperationId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_BATCH_OPERATION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getBatchOperationId() {
    return batchOperationId;
  }

  @JsonProperty(value = JSON_PROPERTY_BATCH_OPERATION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationId(
      @javax.annotation.Nullable StringFilterProperty batchOperationId) {
    this.batchOperationId = batchOperationId;
  }

  public BaseProcessInstanceFilterFields errorMessage(
      @javax.annotation.Nullable StringFilterProperty errorMessage) {

    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * The error message related to the process.
   *
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getErrorMessage() {
    return errorMessage;
  }

  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    this.errorMessage = errorMessage;
  }

  public BaseProcessInstanceFilterFields hasRetriesLeft(
      @javax.annotation.Nullable Boolean hasRetriesLeft) {

    this.hasRetriesLeft = hasRetriesLeft;
    return this;
  }

  /**
   * Whether the process has failed jobs with retries left.
   *
   * @return hasRetriesLeft
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_HAS_RETRIES_LEFT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasRetriesLeft() {
    return hasRetriesLeft;
  }

  @JsonProperty(value = JSON_PROPERTY_HAS_RETRIES_LEFT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRetriesLeft(@javax.annotation.Nullable Boolean hasRetriesLeft) {
    this.hasRetriesLeft = hasRetriesLeft;
  }

  public BaseProcessInstanceFilterFields elementInstanceState(
      @javax.annotation.Nullable ElementInstanceStateFilterProperty elementInstanceState) {

    this.elementInstanceState = elementInstanceState;
    return this;
  }

  /**
   * The state of the element instances associated with the process instance.
   *
   * @return elementInstanceState
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ElementInstanceStateFilterProperty getElementInstanceState() {
    return elementInstanceState;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceState(
      @javax.annotation.Nullable ElementInstanceStateFilterProperty elementInstanceState) {
    this.elementInstanceState = elementInstanceState;
  }

  public BaseProcessInstanceFilterFields elementId(
      @javax.annotation.Nullable StringFilterProperty elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The element id associated with the process instance.
   *
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    this.elementId = elementId;
  }

  public BaseProcessInstanceFilterFields hasElementInstanceIncident(
      @javax.annotation.Nullable Boolean hasElementInstanceIncident) {

    this.hasElementInstanceIncident = hasElementInstanceIncident;
    return this;
  }

  /**
   * Whether the element instance has an incident or not.
   *
   * @return hasElementInstanceIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasElementInstanceIncident() {
    return hasElementInstanceIncident;
  }

  @JsonProperty(value = JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasElementInstanceIncident(
      @javax.annotation.Nullable Boolean hasElementInstanceIncident) {
    this.hasElementInstanceIncident = hasElementInstanceIncident;
  }

  public BaseProcessInstanceFilterFields incidentErrorHashCode(
      @javax.annotation.Nullable IntegerFilterProperty incidentErrorHashCode) {

    this.incidentErrorHashCode = incidentErrorHashCode;
    return this;
  }

  /**
   * The incident error hash code, associated with this process.
   *
   * @return incidentErrorHashCode
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IntegerFilterProperty getIncidentErrorHashCode() {
    return incidentErrorHashCode;
  }

  @JsonProperty(value = JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentErrorHashCode(
      @javax.annotation.Nullable IntegerFilterProperty incidentErrorHashCode) {
    this.incidentErrorHashCode = incidentErrorHashCode;
  }

  public BaseProcessInstanceFilterFields tags(@javax.annotation.Nullable Set<String> tags) {

    this.tags = tags;
    return this;
  }

  public BaseProcessInstanceFilterFields addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags. Tags need to start with a letter; then alphanumerics, &#x60;_&#x60;,
   * &#x60;-&#x60;, &#x60;:&#x60;, or &#x60;.&#x60;; length ≤ 100.
   *
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<String> getTags() {
    return tags;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseProcessInstanceFilterFields baseProcessInstanceFilterFields =
        (BaseProcessInstanceFilterFields) o;
    return Objects.equals(this.startDate, baseProcessInstanceFilterFields.startDate)
        && Objects.equals(this.endDate, baseProcessInstanceFilterFields.endDate)
        && Objects.equals(this.state, baseProcessInstanceFilterFields.state)
        && Objects.equals(this.hasIncident, baseProcessInstanceFilterFields.hasIncident)
        && Objects.equals(this.tenantId, baseProcessInstanceFilterFields.tenantId)
        && Objects.equals(this.variables, baseProcessInstanceFilterFields.variables)
        && Objects.equals(
            this.processInstanceKey, baseProcessInstanceFilterFields.processInstanceKey)
        && Objects.equals(
            this.parentProcessInstanceKey, baseProcessInstanceFilterFields.parentProcessInstanceKey)
        && Objects.equals(
            this.parentElementInstanceKey, baseProcessInstanceFilterFields.parentElementInstanceKey)
        && Objects.equals(this.batchOperationId, baseProcessInstanceFilterFields.batchOperationId)
        && Objects.equals(this.errorMessage, baseProcessInstanceFilterFields.errorMessage)
        && Objects.equals(this.hasRetriesLeft, baseProcessInstanceFilterFields.hasRetriesLeft)
        && Objects.equals(
            this.elementInstanceState, baseProcessInstanceFilterFields.elementInstanceState)
        && Objects.equals(this.elementId, baseProcessInstanceFilterFields.elementId)
        && Objects.equals(
            this.hasElementInstanceIncident,
            baseProcessInstanceFilterFields.hasElementInstanceIncident)
        && Objects.equals(
            this.incidentErrorHashCode, baseProcessInstanceFilterFields.incidentErrorHashCode)
        && Objects.equals(this.tags, baseProcessInstanceFilterFields.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        startDate,
        endDate,
        state,
        hasIncident,
        tenantId,
        variables,
        processInstanceKey,
        parentProcessInstanceKey,
        parentElementInstanceKey,
        batchOperationId,
        errorMessage,
        hasRetriesLeft,
        elementInstanceState,
        elementId,
        hasElementInstanceIncident,
        incidentErrorHashCode,
        tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseProcessInstanceFilterFields {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    parentProcessInstanceKey: ")
        .append(toIndentedString(parentProcessInstanceKey))
        .append("\n");
    sb.append("    parentElementInstanceKey: ")
        .append(toIndentedString(parentElementInstanceKey))
        .append("\n");
    sb.append("    batchOperationId: ").append(toIndentedString(batchOperationId)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    hasRetriesLeft: ").append(toIndentedString(hasRetriesLeft)).append("\n");
    sb.append("    elementInstanceState: ")
        .append(toIndentedString(elementInstanceState))
        .append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    hasElementInstanceIncident: ")
        .append(toIndentedString(hasElementInstanceIncident))
        .append("\n");
    sb.append("    incidentErrorHashCode: ")
        .append(toIndentedString(incidentErrorHashCode))
        .append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
