/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Defines an authorization request. Either an id-based or a property-based authorization can be
 * provided.
 */
@JsonPropertyOrder({
  AuthorizationRequest.JSON_PROPERTY_OWNER_ID,
  AuthorizationRequest.JSON_PROPERTY_OWNER_TYPE,
  AuthorizationRequest.JSON_PROPERTY_RESOURCE_ID,
  AuthorizationRequest.JSON_PROPERTY_RESOURCE_TYPE,
  AuthorizationRequest.JSON_PROPERTY_PERMISSION_TYPES,
  AuthorizationRequest.JSON_PROPERTY_RESOURCE_PROPERTY_NAME
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class AuthorizationRequest {
  public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
  @javax.annotation.Nonnull private String ownerId;

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  @javax.annotation.Nonnull private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  @javax.annotation.Nonnull private String resourceId;

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  @javax.annotation.Nonnull private ResourceTypeEnum resourceType;

  public static final String JSON_PROPERTY_PERMISSION_TYPES = "permissionTypes";
  @javax.annotation.Nonnull private List<PermissionTypeEnum> permissionTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_RESOURCE_PROPERTY_NAME = "resourcePropertyName";
  @javax.annotation.Nonnull private String resourcePropertyName;

  public AuthorizationRequest() {}

  public AuthorizationRequest ownerId(@javax.annotation.Nonnull String ownerId) {

    this.ownerId = ownerId;
    return this;
  }

  /**
   * The ID of the owner of the permissions.
   *
   * @return ownerId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_OWNER_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getOwnerId() {
    return ownerId;
  }

  @JsonProperty(value = JSON_PROPERTY_OWNER_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerId(@javax.annotation.Nonnull String ownerId) {
    this.ownerId = ownerId;
  }

  public AuthorizationRequest ownerType(@javax.annotation.Nonnull OwnerTypeEnum ownerType) {

    this.ownerType = ownerType;
    return this;
  }

  /**
   * Get ownerType
   *
   * @return ownerType
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_OWNER_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }

  @JsonProperty(value = JSON_PROPERTY_OWNER_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerType(@javax.annotation.Nonnull OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }

  public AuthorizationRequest resourceId(@javax.annotation.Nonnull String resourceId) {

    this.resourceId = resourceId;
    return this;
  }

  /**
   * The ID of the resource to add permissions to.
   *
   * @return resourceId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_RESOURCE_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getResourceId() {
    return resourceId;
  }

  @JsonProperty(value = JSON_PROPERTY_RESOURCE_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResourceId(@javax.annotation.Nonnull String resourceId) {
    this.resourceId = resourceId;
  }

  public AuthorizationRequest resourceType(
      @javax.annotation.Nonnull ResourceTypeEnum resourceType) {

    this.resourceType = resourceType;
    return this;
  }

  /**
   * The type of resource to add permissions to.
   *
   * @return resourceType
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_RESOURCE_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public ResourceTypeEnum getResourceType() {
    return resourceType;
  }

  @JsonProperty(value = JSON_PROPERTY_RESOURCE_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResourceType(@javax.annotation.Nonnull ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
  }

  public AuthorizationRequest permissionTypes(
      @javax.annotation.Nonnull List<PermissionTypeEnum> permissionTypes) {

    this.permissionTypes = permissionTypes;
    return this;
  }

  public AuthorizationRequest addPermissionTypesItem(PermissionTypeEnum permissionTypesItem) {
    if (this.permissionTypes == null) {
      this.permissionTypes = new ArrayList<>();
    }
    this.permissionTypes.add(permissionTypesItem);
    return this;
  }

  /**
   * The permission types to add.
   *
   * @return permissionTypes
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PERMISSION_TYPES, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<PermissionTypeEnum> getPermissionTypes() {
    return permissionTypes;
  }

  @JsonProperty(value = JSON_PROPERTY_PERMISSION_TYPES, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPermissionTypes(
      @javax.annotation.Nonnull List<PermissionTypeEnum> permissionTypes) {
    this.permissionTypes = permissionTypes;
  }

  public AuthorizationRequest resourcePropertyName(
      @javax.annotation.Nonnull String resourcePropertyName) {

    this.resourcePropertyName = resourcePropertyName;
    return this;
  }

  /**
   * The name of the resource property on which this authorization is based.
   *
   * @return resourcePropertyName
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_RESOURCE_PROPERTY_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getResourcePropertyName() {
    return resourcePropertyName;
  }

  @JsonProperty(value = JSON_PROPERTY_RESOURCE_PROPERTY_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResourcePropertyName(@javax.annotation.Nonnull String resourcePropertyName) {
    this.resourcePropertyName = resourcePropertyName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationRequest authorizationRequest = (AuthorizationRequest) o;
    return Objects.equals(this.ownerId, authorizationRequest.ownerId)
        && Objects.equals(this.ownerType, authorizationRequest.ownerType)
        && Objects.equals(this.resourceId, authorizationRequest.resourceId)
        && Objects.equals(this.resourceType, authorizationRequest.resourceType)
        && Objects.equals(this.permissionTypes, authorizationRequest.permissionTypes)
        && Objects.equals(this.resourcePropertyName, authorizationRequest.resourcePropertyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        ownerId, ownerType, resourceId, resourceType, permissionTypes, resourcePropertyName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationRequest {\n");
    sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    permissionTypes: ").append(toIndentedString(permissionTypes)).append("\n");
    sb.append("    resourcePropertyName: ")
        .append(toIndentedString(resourcePropertyName))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
