/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/** ActivatedJobResult */
@JsonPropertyOrder({
  ActivatedJobResult.JSON_PROPERTY_TYPE,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ActivatedJobResult.JSON_PROPERTY_ELEMENT_ID,
  ActivatedJobResult.JSON_PROPERTY_CUSTOM_HEADERS,
  ActivatedJobResult.JSON_PROPERTY_WORKER,
  ActivatedJobResult.JSON_PROPERTY_RETRIES,
  ActivatedJobResult.JSON_PROPERTY_DEADLINE,
  ActivatedJobResult.JSON_PROPERTY_VARIABLES,
  ActivatedJobResult.JSON_PROPERTY_TENANT_ID,
  ActivatedJobResult.JSON_PROPERTY_JOB_KEY,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ActivatedJobResult.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  ActivatedJobResult.JSON_PROPERTY_KIND,
  ActivatedJobResult.JSON_PROPERTY_LISTENER_EVENT_TYPE,
  ActivatedJobResult.JSON_PROPERTY_USER_TASK,
  ActivatedJobResult.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class ActivatedJobResult {
  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nonnull private String type;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nonnull private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nonnull private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nonnull private String elementId;

  public static final String JSON_PROPERTY_CUSTOM_HEADERS = "customHeaders";
  @javax.annotation.Nonnull private Map<String, Object> customHeaders = new HashMap<>();

  public static final String JSON_PROPERTY_WORKER = "worker";
  @javax.annotation.Nonnull private String worker;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  @javax.annotation.Nonnull private Integer retries;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  @javax.annotation.Nonnull private Long deadline;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nonnull private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nonnull private String tenantId;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  @javax.annotation.Nonnull private String jobKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nonnull private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nonnull private String processDefinitionKey;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nonnull private String elementInstanceKey;

  public static final String JSON_PROPERTY_KIND = "kind";
  @javax.annotation.Nonnull private JobKindEnum kind;

  public static final String JSON_PROPERTY_LISTENER_EVENT_TYPE = "listenerEventType";
  @javax.annotation.Nonnull private JobListenerEventTypeEnum listenerEventType;

  public static final String JSON_PROPERTY_USER_TASK = "userTask";
  @javax.annotation.Nullable private UserTaskProperties userTask;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable private Set<String> tags = new LinkedHashSet<>();

  public ActivatedJobResult() {}

  public ActivatedJobResult type(@javax.annotation.Nonnull String type) {

    this.type = type;
    return this;
  }

  /**
   * The type of the job (should match what was requested).
   *
   * @return type
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getType() {
    return type;
  }

  @JsonProperty(value = JSON_PROPERTY_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@javax.annotation.Nonnull String type) {
    this.type = type;
  }

  public ActivatedJobResult processDefinitionId(
      @javax.annotation.Nonnull String processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process ID of the job&#39;s process definition.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionId(@javax.annotation.Nonnull String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ActivatedJobResult processDefinitionVersion(
      @javax.annotation.Nonnull Integer processDefinitionVersion) {

    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the job&#39;s process definition.
   *
   * @return processDefinitionVersion
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionVersion(
      @javax.annotation.Nonnull Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ActivatedJobResult elementId(@javax.annotation.Nonnull String elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The associated task element ID.
   *
   * @return elementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementId(@javax.annotation.Nonnull String elementId) {
    this.elementId = elementId;
  }

  public ActivatedJobResult customHeaders(
      @javax.annotation.Nonnull Map<String, Object> customHeaders) {

    this.customHeaders = customHeaders;
    return this;
  }

  public ActivatedJobResult putCustomHeadersItem(String key, Object customHeadersItem) {
    this.customHeaders.put(key, customHeadersItem);
    return this;
  }

  /**
   * A set of custom headers defined during modelling; returned as a serialized JSON document.
   *
   * @return customHeaders
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_CUSTOM_HEADERS, required = true)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.ALWAYS)
  public Map<String, Object> getCustomHeaders() {
    return customHeaders;
  }

  @JsonProperty(value = JSON_PROPERTY_CUSTOM_HEADERS, required = true)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.ALWAYS)
  public void setCustomHeaders(@javax.annotation.Nonnull Map<String, Object> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public ActivatedJobResult worker(@javax.annotation.Nonnull String worker) {

    this.worker = worker;
    return this;
  }

  /**
   * The name of the worker which activated this job.
   *
   * @return worker
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_WORKER, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getWorker() {
    return worker;
  }

  @JsonProperty(value = JSON_PROPERTY_WORKER, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWorker(@javax.annotation.Nonnull String worker) {
    this.worker = worker;
  }

  public ActivatedJobResult retries(@javax.annotation.Nonnull Integer retries) {

    this.retries = retries;
    return this;
  }

  /**
   * The amount of retries left to this job (should always be positive).
   *
   * @return retries
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_RETRIES, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getRetries() {
    return retries;
  }

  @JsonProperty(value = JSON_PROPERTY_RETRIES, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRetries(@javax.annotation.Nonnull Integer retries) {
    this.retries = retries;
  }

  public ActivatedJobResult deadline(@javax.annotation.Nonnull Long deadline) {

    this.deadline = deadline;
    return this;
  }

  /**
   * When the job can be activated again, sent as a UNIX epoch timestamp.
   *
   * @return deadline
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_DEADLINE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getDeadline() {
    return deadline;
  }

  @JsonProperty(value = JSON_PROPERTY_DEADLINE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDeadline(@javax.annotation.Nonnull Long deadline) {
    this.deadline = deadline;
  }

  public ActivatedJobResult variables(@javax.annotation.Nonnull Map<String, Object> variables) {

    this.variables = variables;
    return this;
  }

  public ActivatedJobResult putVariablesItem(String key, Object variablesItem) {
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All variables visible to the task scope, computed at activation time.
   *
   * @return variables
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = true)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.ALWAYS)
  public Map<String, Object> getVariables() {
    return variables;
  }

  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = true)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.ALWAYS)
  public void setVariables(@javax.annotation.Nonnull Map<String, Object> variables) {
    this.variables = variables;
  }

  public ActivatedJobResult tenantId(@javax.annotation.Nonnull String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The ID of the tenant that owns the job.
   *
   * @return tenantId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTenantId(@javax.annotation.Nonnull String tenantId) {
    this.tenantId = tenantId;
  }

  public ActivatedJobResult jobKey(@javax.annotation.Nonnull String jobKey) {

    this.jobKey = jobKey;
    return this;
  }

  /**
   * The key, a unique identifier for the job.
   *
   * @return jobKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_JOB_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getJobKey() {
    return jobKey;
  }

  @JsonProperty(value = JSON_PROPERTY_JOB_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setJobKey(@javax.annotation.Nonnull String jobKey) {
    this.jobKey = jobKey;
  }

  public ActivatedJobResult processInstanceKey(
      @javax.annotation.Nonnull String processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The job&#39;s process instance key.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessInstanceKey(@javax.annotation.Nonnull String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ActivatedJobResult processDefinitionKey(
      @javax.annotation.Nonnull String processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the job&#39;s process definition.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionKey(@javax.annotation.Nonnull String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ActivatedJobResult elementInstanceKey(
      @javax.annotation.Nonnull String elementInstanceKey) {

    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * Get elementInstanceKey
   *
   * @return elementInstanceKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getElementInstanceKey() {
    return elementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementInstanceKey(@javax.annotation.Nonnull String elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ActivatedJobResult kind(@javax.annotation.Nonnull JobKindEnum kind) {

    this.kind = kind;
    return this;
  }

  /**
   * Get kind
   *
   * @return kind
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_KIND, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public JobKindEnum getKind() {
    return kind;
  }

  @JsonProperty(value = JSON_PROPERTY_KIND, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKind(@javax.annotation.Nonnull JobKindEnum kind) {
    this.kind = kind;
  }

  public ActivatedJobResult listenerEventType(
      @javax.annotation.Nonnull JobListenerEventTypeEnum listenerEventType) {

    this.listenerEventType = listenerEventType;
    return this;
  }

  /**
   * Get listenerEventType
   *
   * @return listenerEventType
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_LISTENER_EVENT_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public JobListenerEventTypeEnum getListenerEventType() {
    return listenerEventType;
  }

  @JsonProperty(value = JSON_PROPERTY_LISTENER_EVENT_TYPE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListenerEventType(
      @javax.annotation.Nonnull JobListenerEventTypeEnum listenerEventType) {
    this.listenerEventType = listenerEventType;
  }

  public ActivatedJobResult userTask(@javax.annotation.Nullable UserTaskProperties userTask) {

    this.userTask = userTask;
    return this;
  }

  /**
   * Get userTask
   *
   * @return userTask
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_USER_TASK, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public UserTaskProperties getUserTask() {
    return userTask;
  }

  @JsonProperty(value = JSON_PROPERTY_USER_TASK, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserTask(@javax.annotation.Nullable UserTaskProperties userTask) {
    this.userTask = userTask;
  }

  public ActivatedJobResult tags(@javax.annotation.Nullable Set<String> tags) {

    this.tags = tags;
    return this;
  }

  public ActivatedJobResult addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags. Tags need to start with a letter; then alphanumerics, &#x60;_&#x60;,
   * &#x60;-&#x60;, &#x60;:&#x60;, or &#x60;.&#x60;; length ≤ 100.
   *
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<String> getTags() {
    return tags;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivatedJobResult activatedJobResult = (ActivatedJobResult) o;
    return Objects.equals(this.type, activatedJobResult.type)
        && Objects.equals(this.processDefinitionId, activatedJobResult.processDefinitionId)
        && Objects.equals(
            this.processDefinitionVersion, activatedJobResult.processDefinitionVersion)
        && Objects.equals(this.elementId, activatedJobResult.elementId)
        && Objects.equals(this.customHeaders, activatedJobResult.customHeaders)
        && Objects.equals(this.worker, activatedJobResult.worker)
        && Objects.equals(this.retries, activatedJobResult.retries)
        && Objects.equals(this.deadline, activatedJobResult.deadline)
        && Objects.equals(this.variables, activatedJobResult.variables)
        && Objects.equals(this.tenantId, activatedJobResult.tenantId)
        && Objects.equals(this.jobKey, activatedJobResult.jobKey)
        && Objects.equals(this.processInstanceKey, activatedJobResult.processInstanceKey)
        && Objects.equals(this.processDefinitionKey, activatedJobResult.processDefinitionKey)
        && Objects.equals(this.elementInstanceKey, activatedJobResult.elementInstanceKey)
        && Objects.equals(this.kind, activatedJobResult.kind)
        && Objects.equals(this.listenerEventType, activatedJobResult.listenerEventType)
        && Objects.equals(this.userTask, activatedJobResult.userTask)
        && Objects.equals(this.tags, activatedJobResult.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        type,
        processDefinitionId,
        processDefinitionVersion,
        elementId,
        customHeaders,
        worker,
        retries,
        deadline,
        variables,
        tenantId,
        jobKey,
        processInstanceKey,
        processDefinitionKey,
        elementInstanceKey,
        kind,
        listenerEventType,
        userTask,
        tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivatedJobResult {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    processDefinitionVersion: ")
        .append(toIndentedString(processDefinitionVersion))
        .append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    customHeaders: ").append(toIndentedString(customHeaders)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    listenerEventType: ").append(toIndentedString(listenerEventType)).append("\n");
    sb.append("    userTask: ").append(toIndentedString(userTask)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
