/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.zeebe.client.protocol.rest.UserFilter;
import io.camunda.zeebe.client.protocol.rest.UserSearchQuerySortRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"sort", "filter", "page"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserSearchQueryRequest {
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private List<UserSearchQuerySortRequest> sort = new ArrayList<UserSearchQuerySortRequest>();
    public static final String JSON_PROPERTY_FILTER = "filter";
    @Nullable
    private UserFilter filter;
    public static final String JSON_PROPERTY_PAGE = "page";
    @Nullable
    private SearchQueryPageRequest page;

    public UserSearchQueryRequest sort(@Nullable List<UserSearchQuerySortRequest> sort) {
        this.sort = sort;
        return this;
    }

    public UserSearchQueryRequest addSortItem(UserSearchQuerySortRequest sortItem) {
        if (this.sort == null) {
            this.sort = new ArrayList<UserSearchQuerySortRequest>();
        }
        this.sort.add(sortItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UserSearchQuerySortRequest> getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable List<UserSearchQuerySortRequest> sort) {
        this.sort = sort;
    }

    public UserSearchQueryRequest filter(@Nullable UserFilter filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFilter getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(@Nullable UserFilter filter) {
        this.filter = filter;
    }

    public UserSearchQueryRequest page(@Nullable SearchQueryPageRequest page) {
        this.page = page;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchQueryPageRequest getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(@Nullable SearchQueryPageRequest page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSearchQueryRequest userSearchQueryRequest = (UserSearchQueryRequest)o;
        return Objects.equals(this.sort, userSearchQueryRequest.sort) && Objects.equals(this.filter, userSearchQueryRequest.filter) && Objects.equals(this.page, userSearchQueryRequest.page);
    }

    public int hashCode() {
        return Objects.hash(this.sort, this.filter, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSearchQueryRequest {\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPage() != null) {
            joiner.add(this.getPage().toUrlQueryString(prefix + JSON_PROPERTY_PAGE + suffix));
        }
        return joiner.toString();
    }
}

