/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.worker;

import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import java.util.Random;

public final class ExponentialBackoff
implements BackoffSupplier {
    private final long maxDelay;
    private final long minDelay;
    private final double backoffFactor;
    private final double jitterFactor;
    private final Random random;

    public ExponentialBackoff(long maxDelay, long minDelay, double backoffFactor, double jitterFactor, Random random) {
        this.maxDelay = maxDelay;
        this.minDelay = minDelay;
        this.backoffFactor = backoffFactor;
        this.jitterFactor = jitterFactor;
        this.random = random;
    }

    @Override
    public long supplyRetryDelay(long currentRetryDelay) {
        double delay = Math.max(Math.min((double)this.maxDelay, (double)currentRetryDelay * this.backoffFactor), (double)this.minDelay);
        double jitter = this.computeJitter(delay);
        return Math.round(delay + jitter);
    }

    private double computeJitter(double value) {
        double minFactor = value * -this.jitterFactor;
        double maxFactor = value * this.jitterFactor;
        return this.random.nextDouble() * (maxFactor - minFactor) + minFactor;
    }
}

