/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.camunda.zeebe.client.impl.http.ApiEntity;
import io.camunda.zeebe.client.protocol.rest.ProblemDetail;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public interface TypedApiEntityConsumer<T> {
    public ApiEntity<T> generateContent() throws IOException;

    public void consumeData(ByteBuffer var1, boolean var2) throws IOException;

    public void releaseResources();

    public int getBufferedBytes();

    public static class RawApiEntityConsumer<T>
    implements TypedApiEntityConsumer<T> {
        private final boolean isResponse;
        private final int maxCapacity;
        private byte[] body = new byte[1024];
        private int bufferedBytes;

        public RawApiEntityConsumer(boolean isResponse, int maxCapacity) {
            this.isResponse = isResponse;
            this.maxCapacity = maxCapacity;
        }

        @Override
        public ApiEntity<T> generateContent() {
            if (this.bufferedBytes == 0) {
                return null;
            }
            if (this.isResponse) {
                return ApiEntity.of(new String(this.body, 0, this.bufferedBytes, StandardCharsets.UTF_8));
            }
            return ApiEntity.of(ByteBuffer.wrap(this.body, 0, this.bufferedBytes));
        }

        @Override
        public void consumeData(ByteBuffer src, boolean endOfStream) {
            int offset = this.bufferedBytes;
            this.bufferedBytes += src.remaining();
            if (this.body.length < this.bufferedBytes) {
                if (this.bufferedBytes > this.maxCapacity) {
                    throw new IllegalArgumentException("The message size exceeds the maximum allowed size of " + this.maxCapacity);
                }
                this.body = Arrays.copyOf(this.body, this.bufferedBytes);
            }
            src.get(this.body, offset, src.remaining());
        }

        @Override
        public void releaseResources() {
            this.bufferedBytes = 0;
        }

        @Override
        public int getBufferedBytes() {
            return this.bufferedBytes;
        }
    }

    public static class JsonApiEntityConsumer<T>
    implements TypedApiEntityConsumer<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiEntityConsumer.class);
        private final ObjectMapper json;
        private final Class<T> type;
        private final NonBlockingByteBufferJsonParser parser;
        private final TokenBuffer buffer;
        private final boolean isResponse;
        private int bufferedBytes;

        public JsonApiEntityConsumer(ObjectMapper json, Class<T> type, boolean isResponse) throws IOException {
            this.json = json;
            this.type = type;
            this.isResponse = isResponse;
            this.parser = (NonBlockingByteBufferJsonParser)json.getFactory().createNonBlockingByteBufferParser();
            this.buffer = new TokenBuffer((JsonParser)this.parser, json.getDeserializationContext());
        }

        @Override
        public ApiEntity<T> generateContent() throws IOException {
            try {
                if (this.isResponse) {
                    return ApiEntity.of(this.json.readValue(this.buffer.asParserOnFirstToken(), this.type));
                }
                return ApiEntity.of((ProblemDetail)this.json.readValue(this.buffer.asParserOnFirstToken(), ProblemDetail.class));
            }
            catch (IOException ioe) {
                String jsonString = this.getJsonString();
                return ApiEntity.of(new ProblemDetail().title("Unexpected server response").status(500).detail(jsonString));
            }
        }

        @Override
        public void consumeData(ByteBuffer src, boolean endOfStream) throws IOException {
            this.bufferedBytes += src.remaining();
            this.parser.feedInput(src);
            JsonToken jsonToken = this.parser.nextToken();
            while (jsonToken != null && jsonToken != JsonToken.NOT_AVAILABLE) {
                this.buffer.copyCurrentEvent((JsonParser)this.parser);
                jsonToken = this.parser.nextToken();
            }
            if (endOfStream) {
                this.parser.endOfInput();
            }
        }

        @Override
        public void releaseResources() {
            try {
                this.parser.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close JSON parser", (Throwable)e);
            }
            try {
                this.buffer.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close JSON buffer", (Throwable)e);
            }
            this.bufferedBytes = 0;
        }

        @Override
        public int getBufferedBytes() {
            return this.bufferedBytes;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private String getJsonString() {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                String string;
                block13: {
                    JsonGenerator generator = this.json.createGenerator((OutputStream)output);
                    try {
                        this.buffer.serialize(generator);
                        generator.flush();
                        string = output.toString(StandardCharsets.UTF_8.name());
                        if (generator == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (generator != null) {
                            try {
                                generator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    generator.close();
                }
                return string;
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to serialize JSON string", (Throwable)ex);
                return "Original response cannot be constructed";
            }
        }
    }
}

