/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.oauth;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.impl.ZeebeClientCredentials;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsCache;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.VersionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class OAuthCredentialsProvider
implements CredentialsProvider {
    private static final String HEADER_AUTH_KEY = "Authorization";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final ObjectReader CREDENTIALS_READER = JSON_MAPPER.readerFor(ZeebeClientCredentials.class);
    private static final Logger LOG = LoggerFactory.getLogger(OAuthCredentialsProvider.class);
    private final URL authorizationServerUrl;
    private final String payload;
    private final String clientId;
    private final OAuthCredentialsCache credentialsCache;
    private final Duration connectionTimeout;
    private final Duration readTimeout;

    OAuthCredentialsProvider(OAuthCredentialsProviderBuilder builder) {
        this.authorizationServerUrl = builder.getAuthorizationServer();
        this.clientId = builder.getClientId();
        this.payload = OAuthCredentialsProvider.createParams(builder);
        this.credentialsCache = new OAuthCredentialsCache(builder.getCredentialsCache());
        this.connectionTimeout = builder.getConnectTimeout();
        this.readTimeout = builder.getReadTimeout();
    }

    @Override
    public void applyCredentials(CredentialsProvider.CredentialsApplier applier) throws IOException {
        ZeebeClientCredentials zeebeClientCredentials = this.credentialsCache.computeIfMissingOrInvalid(this.clientId, this::fetchCredentials);
        String type = zeebeClientCredentials.getTokenType();
        if (type == null || type.isEmpty()) {
            throw new IOException(String.format("Expected valid token type but was absent or invalid '%s'", type));
        }
        type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
        applier.put(HEADER_AUTH_KEY, String.format("%s %s", type, zeebeClientCredentials.getAccessToken()));
    }

    @Override
    public boolean shouldRetryRequest(CredentialsProvider.StatusCode statusCode) {
        try {
            return statusCode.isUnauthorized() && this.credentialsCache.withCache(this.clientId, value -> {
                ZeebeClientCredentials fetchedCredentials = this.fetchCredentials();
                this.credentialsCache.put(this.clientId, fetchedCredentials).writeCache();
                return !fetchedCredentials.equals(value) || !value.isValid();
            }).orElse(false) != false;
        }
        catch (IOException e) {
            LOG.error("Failed while fetching credentials: ", (Throwable)e);
            return false;
        }
    }

    private static String createParams(OAuthCredentialsProviderBuilder builder) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("client_id", builder.getClientId());
        payload.put("client_secret", builder.getClientSecret());
        payload.put("audience", builder.getAudience());
        payload.put("grant_type", "client_credentials");
        String scope = builder.getScope();
        if (scope != null) {
            payload.put("scope", scope);
        }
        return payload.entrySet().stream().map(e -> OAuthCredentialsProvider.encode((String)e.getKey()) + "=" + OAuthCredentialsProvider.encode((String)e.getValue())).collect(Collectors.joining("&"));
    }

    private static String encode(String param) {
        try {
            return URLEncoder.encode(param, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException("Failed while encoding OAuth request parameters: ", e);
        }
    }

    private ZeebeClientCredentials fetchCredentials() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.authorizationServerUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoOutput(true);
        connection.setReadTimeout(Math.toIntExact(this.readTimeout.toMillis()));
        connection.setConnectTimeout(Math.toIntExact(this.connectionTimeout.toMillis()));
        connection.setRequestProperty("User-Agent", "zeebe-client-java/" + VersionUtil.getVersion());
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = this.payload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException(String.format("Failed while requesting access token with status code %d and message %s.", connection.getResponseCode(), connection.getResponseMessage()));
        }
        try (InputStream in = connection.getInputStream();){
            ZeebeClientCredentials zeebeClientCredentials;
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                ZeebeClientCredentials fetchedCredentials = (ZeebeClientCredentials)CREDENTIALS_READER.readValue((Reader)reader);
                if (fetchedCredentials == null) {
                    throw new IOException("Expected valid credentials but got null instead.");
                }
                zeebeClientCredentials = fetchedCredentials;
            }
            return zeebeClientCredentials;
        }
    }
}

