/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A deployed decision.
 */
@JsonPropertyOrder({
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_KEY,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_ID,
  DeploymentDecisionResult.JSON_PROPERTY_VERSION,
  DeploymentDecisionResult.JSON_PROPERTY_NAME,
  DeploymentDecisionResult.JSON_PROPERTY_TENANT_ID,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-07T09:07:49.077422923Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentDecisionResult {
  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  private String decisionDefinitionKey;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_KEY = "decisionRequirementsKey";
  private String decisionRequirementsKey;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_ID = "decisionRequirementsId";
  private String decisionRequirementsId;

  public DeploymentDecisionResult() {
  }

  public DeploymentDecisionResult decisionDefinitionKey(String decisionDefinitionKey) {
    
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The assigned decision key, which acts as a unique identifier for this decision. 
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionKey(String decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DeploymentDecisionResult decisionRequirementsKey(String decisionRequirementsKey) {
    
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned key of the decision requirements graph that this decision is part of. 
   * @return decisionRequirementsKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsKey(String decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public DeploymentDecisionResult decisionDefinitionId(String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The dmn decision ID, as parsed during deployment, together with the version forms a unique identifier for a specific decision. 
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DeploymentDecisionResult version(Integer version) {
    
    this.version = version;
    return this;
  }

  /**
   * The assigned decision version.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Integer version) {
    this.version = version;
  }

  public DeploymentDecisionResult name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The DMN name of the decision, as parsed during deployment.
   * @return name
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  public DeploymentDecisionResult tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed decision.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public DeploymentDecisionResult decisionRequirementsId(String decisionRequirementsId) {
    
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The dmn ID of the decision requirements graph that this decision is part of, as parsed during deployment. 
   * @return decisionRequirementsId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentDecisionResult deploymentDecisionResult = (DeploymentDecisionResult) o;
    return Objects.equals(this.decisionDefinitionKey, deploymentDecisionResult.decisionDefinitionKey) &&
        Objects.equals(this.decisionRequirementsKey, deploymentDecisionResult.decisionRequirementsKey) &&
        Objects.equals(this.decisionDefinitionId, deploymentDecisionResult.decisionDefinitionId) &&
        Objects.equals(this.version, deploymentDecisionResult.version) &&
        Objects.equals(this.name, deploymentDecisionResult.name) &&
        Objects.equals(this.tenantId, deploymentDecisionResult.tenantId) &&
        Objects.equals(this.decisionRequirementsId, deploymentDecisionResult.decisionRequirementsId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionKey, decisionRequirementsKey, decisionDefinitionId, version, name, tenantId, decisionRequirementsId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentDecisionResult {\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsId` to the URL query string
    if (getDecisionRequirementsId() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

