/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceTypeEnum;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * DecisionInstanceItem
 * @deprecated
 */
@Deprecated
@JsonPropertyOrder({
  DecisionInstanceItem.JSON_PROPERTY_KEY,
  DecisionInstanceItem.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  DecisionInstanceItem.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  DecisionInstanceItem.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  DecisionInstanceItem.JSON_PROPERTY_STATE,
  DecisionInstanceItem.JSON_PROPERTY_EVALUATION_DATE,
  DecisionInstanceItem.JSON_PROPERTY_EVALUATION_FAILURE,
  DecisionInstanceItem.JSON_PROPERTY_DECISION_DEFINITION_ID,
  DecisionInstanceItem.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  DecisionInstanceItem.JSON_PROPERTY_DECISION_DEFINITION_VERSION,
  DecisionInstanceItem.JSON_PROPERTY_DECISION_DEFINITION_TYPE,
  DecisionInstanceItem.JSON_PROPERTY_RESULT,
  DecisionInstanceItem.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-07T09:07:49.077422923Z[GMT]", comments = "Generator version: 7.8.0")
public class DecisionInstanceItem {
  public static final String JSON_PROPERTY_KEY = "key";
  private Long key;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private Long processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  private Long processInstanceKey;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  private Long decisionDefinitionKey;

  public static final String JSON_PROPERTY_STATE = "state";
  private DecisionInstanceStateEnum state;

  public static final String JSON_PROPERTY_EVALUATION_DATE = "evaluationDate";
  private String evaluationDate;

  public static final String JSON_PROPERTY_EVALUATION_FAILURE = "evaluationFailure";
  private String evaluationFailure;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  private String decisionDefinitionName;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_VERSION = "decisionDefinitionVersion";
  private Integer decisionDefinitionVersion;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_TYPE = "decisionDefinitionType";
  private DecisionInstanceTypeEnum decisionDefinitionType;

  public static final String JSON_PROPERTY_RESULT = "result";
  private String result;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public DecisionInstanceItem() {
  }

  public DecisionInstanceItem key(Long key) {
    
    this.key = key;
    return this;
  }

  /**
   * The key of the decision instance.
   * @return key
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getKey() {
    return key;
  }


  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKey(Long key) {
    this.key = key;
  }

  public DecisionInstanceItem processDefinitionKey(Long processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public DecisionInstanceItem processInstanceKey(Long processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of the process instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public DecisionInstanceItem decisionDefinitionKey(Long decisionDefinitionKey) {
    
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The key of the decision.
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DecisionInstanceItem state(DecisionInstanceStateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DecisionInstanceStateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(DecisionInstanceStateEnum state) {
    this.state = state;
  }

  public DecisionInstanceItem evaluationDate(String evaluationDate) {
    
    this.evaluationDate = evaluationDate;
    return this;
  }

  /**
   * The evaluation date of the decision instance.
   * @return evaluationDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEvaluationDate() {
    return evaluationDate;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationDate(String evaluationDate) {
    this.evaluationDate = evaluationDate;
  }

  public DecisionInstanceItem evaluationFailure(String evaluationFailure) {
    
    this.evaluationFailure = evaluationFailure;
    return this;
  }

  /**
   * The evaluation failure of the decision instance.
   * @return evaluationFailure
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_FAILURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEvaluationFailure() {
    return evaluationFailure;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_FAILURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationFailure(String evaluationFailure) {
    this.evaluationFailure = evaluationFailure;
  }

  public DecisionInstanceItem decisionDefinitionId(String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the DMN decision.
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DecisionInstanceItem decisionDefinitionName(String decisionDefinitionName) {
    
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the DMN decision.
   * @return decisionDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public DecisionInstanceItem decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision.
   * @return decisionDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public DecisionInstanceItem decisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
    
    this.decisionDefinitionType = decisionDefinitionType;
    return this;
  }

  /**
   * Get decisionDefinitionType
   * @return decisionDefinitionType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DecisionInstanceTypeEnum getDecisionDefinitionType() {
    return decisionDefinitionType;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
  }

  public DecisionInstanceItem result(String result) {
    
    this.result = result;
    return this;
  }

  /**
   * The result of the decision instance.
   * @return result
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResult() {
    return result;
  }


  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResult(String result) {
    this.result = result;
  }

  public DecisionInstanceItem tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the decision instance.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionInstanceItem decisionInstanceItem = (DecisionInstanceItem) o;
    return Objects.equals(this.key, decisionInstanceItem.key) &&
        Objects.equals(this.processDefinitionKey, decisionInstanceItem.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, decisionInstanceItem.processInstanceKey) &&
        Objects.equals(this.decisionDefinitionKey, decisionInstanceItem.decisionDefinitionKey) &&
        Objects.equals(this.state, decisionInstanceItem.state) &&
        Objects.equals(this.evaluationDate, decisionInstanceItem.evaluationDate) &&
        Objects.equals(this.evaluationFailure, decisionInstanceItem.evaluationFailure) &&
        Objects.equals(this.decisionDefinitionId, decisionInstanceItem.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, decisionInstanceItem.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, decisionInstanceItem.decisionDefinitionVersion) &&
        Objects.equals(this.decisionDefinitionType, decisionInstanceItem.decisionDefinitionType) &&
        Objects.equals(this.result, decisionInstanceItem.result) &&
        Objects.equals(this.tenantId, decisionInstanceItem.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, processDefinitionKey, processInstanceKey, decisionDefinitionKey, state, evaluationDate, evaluationFailure, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionDefinitionType, result, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionInstanceItem {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    evaluationDate: ").append(toIndentedString(evaluationDate)).append("\n");
    sb.append("    evaluationFailure: ").append(toIndentedString(evaluationFailure)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionDefinitionType: ").append(toIndentedString(decisionDefinitionType)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `evaluationDate` to the URL query string
    if (getEvaluationDate() != null) {
      try {
        joiner.add(String.format("%sevaluationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEvaluationDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `evaluationFailure` to the URL query string
    if (getEvaluationFailure() != null) {
      try {
        joiner.add(String.format("%sevaluationFailure%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEvaluationFailure()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionName` to the URL query string
    if (getDecisionDefinitionName() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionVersion` to the URL query string
    if (getDecisionDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionType` to the URL query string
    if (getDecisionDefinitionType() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `result` to the URL query string
    if (getResult() != null) {
      try {
        joiner.add(String.format("%sresult%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResult()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

