/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JSON object with changed task attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * &#x60;candidateGroups&#x60; - reset by providing an empty list * &#x60;candidateUsers&#x60; - reset by providing an empty list * &#x60;dueDate&#x60; - reset by providing an empty String * &#x60;followUpDate&#x60; - reset by providing an empty String * &#x60;priority&#x60; - minimum 0, maximum 100, default 50  Providing any of those attributes with a &#x60;null&#x60; value or omitting it preserves the persisted attribute&#39;s value.  The assignee cannot be adjusted with this endpoint, use the Assign task endpoint. This ensures correct event emission for assignee changes. 
 */
@JsonPropertyOrder({
  Changeset.JSON_PROPERTY_DUE_DATE,
  Changeset.JSON_PROPERTY_FOLLOW_UP_DATE,
  Changeset.JSON_PROPERTY_CANDIDATE_USERS,
  Changeset.JSON_PROPERTY_CANDIDATE_GROUPS,
  Changeset.JSON_PROPERTY_PRIORITY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-07T09:07:49.077422923Z[GMT]", comments = "Generator version: 7.8.0")
public class Changeset extends HashMap<String, Object> {
  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private String dueDate;

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
  private String followUpDate;

  public static final String JSON_PROPERTY_CANDIDATE_USERS = "candidateUsers";
  private List<String> candidateUsers;

  public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
  private List<String> candidateGroups;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private Integer priority = 50;

  public Changeset() {

  }

  public Changeset dueDate(String dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

  /**
   * The due date of the task. Reset by providing an empty String.
   * @return dueDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDueDate() {
    return dueDate;
  }


  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(String dueDate) {
    this.dueDate = dueDate;
  }

  public Changeset followUpDate(String followUpDate) {
    
    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * The follow-up date of the task. Reset by providing an empty String.
   * @return followUpDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFollowUpDate() {
    return followUpDate;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowUpDate(String followUpDate) {
    this.followUpDate = followUpDate;
  }

  public Changeset candidateUsers(List<String> candidateUsers) {
    
    this.candidateUsers = candidateUsers;
    return this;
  }

  public Changeset addCandidateUsersItem(String candidateUsersItem) {
    if (this.candidateUsers == null) {
      this.candidateUsers = new ArrayList<>();
    }
    this.candidateUsers.add(candidateUsersItem);
    return this;
  }

  /**
   * The list of candidate users of the task. Reset by providing an empty list.
   * @return candidateUsers
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCandidateUsers() {
    return candidateUsers;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateUsers(List<String> candidateUsers) {
    this.candidateUsers = candidateUsers;
  }

  public Changeset candidateGroups(List<String> candidateGroups) {
    
    this.candidateGroups = candidateGroups;
    return this;
  }

  public Changeset addCandidateGroupsItem(String candidateGroupsItem) {
    if (this.candidateGroups == null) {
      this.candidateGroups = new ArrayList<>();
    }
    this.candidateGroups.add(candidateGroupsItem);
    return this;
  }

  /**
   * The list of candidate groups of the task. Reset by providing an empty list.
   * @return candidateGroups
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCandidateGroups() {
    return candidateGroups;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateGroups(List<String> candidateGroups) {
    this.candidateGroups = candidateGroups;
  }

  public Changeset priority(Integer priority) {
    
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the task.
   * minimum: 0
   * maximum: 100
   * @return priority
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Changeset changeset = (Changeset) o;
    return Objects.equals(this.dueDate, changeset.dueDate) &&
        Objects.equals(this.followUpDate, changeset.followUpDate) &&
        Objects.equals(this.candidateUsers, changeset.candidateUsers) &&
        Objects.equals(this.candidateGroups, changeset.candidateGroups) &&
        Objects.equals(this.priority, changeset.priority) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dueDate, followUpDate, candidateUsers, candidateGroups, priority, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Changeset {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    candidateUsers: ").append(toIndentedString(candidateUsers)).append("\n");
    sb.append("    candidateGroups: ").append(toIndentedString(candidateGroups)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `dueDate` to the URL query string
    if (getDueDate() != null) {
      try {
        joiner.add(String.format("%sdueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpDate` to the URL query string
    if (getFollowUpDate() != null) {
      try {
        joiner.add(String.format("%sfollowUpDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateUsers` to the URL query string
    if (getCandidateUsers() != null) {
      for (int i = 0; i < getCandidateUsers().size(); i++) {
        try {
          joiner.add(String.format("%scandidateUsers%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateUsers().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `candidateGroups` to the URL query string
    if (getCandidateGroups() != null) {
      for (int i = 0; i < getCandidateGroups().size(); i++) {
        try {
          joiner.add(String.format("%scandidateGroups%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

