/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * The mapping instructions describe how to map elements from the source process definition to the target process definition. 
 */
@JsonPropertyOrder({
  MigrateProcessInstanceMappingInstruction.JSON_PROPERTY_SOURCE_ELEMENT_ID,
  MigrateProcessInstanceMappingInstruction.JSON_PROPERTY_TARGET_ELEMENT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-12T11:21:31.866764793Z[GMT]", comments = "Generator version: 7.8.0")
public class MigrateProcessInstanceMappingInstruction {
  public static final String JSON_PROPERTY_SOURCE_ELEMENT_ID = "sourceElementId";
  private String sourceElementId;

  public static final String JSON_PROPERTY_TARGET_ELEMENT_ID = "targetElementId";
  private String targetElementId;

  public MigrateProcessInstanceMappingInstruction() {
  }

  public MigrateProcessInstanceMappingInstruction sourceElementId(String sourceElementId) {
    
    this.sourceElementId = sourceElementId;
    return this;
  }

  /**
   * The element ID to migrate from.
   * @return sourceElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SOURCE_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceElementId() {
    return sourceElementId;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceElementId(String sourceElementId) {
    this.sourceElementId = sourceElementId;
  }

  public MigrateProcessInstanceMappingInstruction targetElementId(String targetElementId) {
    
    this.targetElementId = targetElementId;
    return this;
  }

  /**
   * The element ID to migrate into.
   * @return targetElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TARGET_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetElementId() {
    return targetElementId;
  }


  @JsonProperty(JSON_PROPERTY_TARGET_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTargetElementId(String targetElementId) {
    this.targetElementId = targetElementId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrateProcessInstanceMappingInstruction migrateProcessInstanceMappingInstruction = (MigrateProcessInstanceMappingInstruction) o;
    return Objects.equals(this.sourceElementId, migrateProcessInstanceMappingInstruction.sourceElementId) &&
        Objects.equals(this.targetElementId, migrateProcessInstanceMappingInstruction.targetElementId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceElementId, targetElementId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrateProcessInstanceMappingInstruction {\n");
    sb.append("    sourceElementId: ").append(toIndentedString(sourceElementId)).append("\n");
    sb.append("    targetElementId: ").append(toIndentedString(targetElementId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `sourceElementId` to the URL query string
    if (getSourceElementId() != null) {
      try {
        joiner.add(String.format("%ssourceElementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSourceElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `targetElementId` to the URL query string
    if (getTargetElementId() != null) {
      try {
        joiner.add(String.format("%stargetElementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTargetElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

