/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Base properties for IncidentItem
 */
@JsonPropertyOrder({
  IncidentItemBase.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  IncidentItemBase.JSON_PROPERTY_ERROR_TYPE,
  IncidentItemBase.JSON_PROPERTY_ERROR_MESSAGE,
  IncidentItemBase.JSON_PROPERTY_FLOW_NODE_ID,
  IncidentItemBase.JSON_PROPERTY_CREATION_TIME,
  IncidentItemBase.JSON_PROPERTY_STATE,
  IncidentItemBase.JSON_PROPERTY_TREE_PATH,
  IncidentItemBase.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-12T11:21:31.866764793Z[GMT]", comments = "Generator version: 7.8.0")
public class IncidentItemBase {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private String processDefinitionId;

  /**
   * Incident error type with a defined set of values.
   */
  public enum ErrorTypeEnum {
    UNSPECIFIED("UNSPECIFIED"),
    
    UNKNOWN("UNKNOWN"),
    
    IO_MAPPING_ERROR("IO_MAPPING_ERROR"),
    
    JOB_NO_RETRIES("JOB_NO_RETRIES"),
    
    CONDITION_ERROR("CONDITION_ERROR"),
    
    EXTRACT_VALUE_ERROR("EXTRACT_VALUE_ERROR"),
    
    CALLED_ELEMENT_ERROR("CALLED_ELEMENT_ERROR"),
    
    UNHANDLED_ERROR_EVENT("UNHANDLED_ERROR_EVENT"),
    
    MESSAGE_SIZE_EXCEEDED("MESSAGE_SIZE_EXCEEDED"),
    
    CALLED_DECISION_ERROR("CALLED_DECISION_ERROR"),
    
    DECISION_EVALUATION_ERROR("DECISION_EVALUATION_ERROR"),
    
    FORM_NOT_FOUND("FORM_NOT_FOUND"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ErrorTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorTypeEnum fromValue(String value) {
      for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
  private ErrorTypeEnum errorType;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private String errorMessage;

  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  private String flowNodeId;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  private String creationTime;

  /**
   * State of this incident with a defined set of values.
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    MIGRATED("MIGRATED"),
    
    RESOLVED("RESOLVED"),
    
    PENDING("PENDING"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_TREE_PATH = "treePath";
  private String treePath;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public IncidentItemBase() {
  }

  public IncidentItemBase processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process id associated to this incident.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public IncidentItemBase errorType(ErrorTypeEnum errorType) {
    
    this.errorType = errorType;
    return this;
  }

  /**
   * Incident error type with a defined set of values.
   * @return errorType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorTypeEnum getErrorType() {
    return errorType;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorType(ErrorTypeEnum errorType) {
    this.errorType = errorType;
  }

  public IncidentItemBase errorMessage(String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Error message which describes the error in more detail.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IncidentItemBase flowNodeId(String flowNodeId) {
    
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node id associated to this incident.
   * @return flowNodeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeId() {
    return flowNodeId;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public IncidentItemBase creationTime(String creationTime) {
    
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Date of incident creation.
   * @return creationTime
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationTime() {
    return creationTime;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationTime(String creationTime) {
    this.creationTime = creationTime;
  }

  public IncidentItemBase state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of this incident with a defined set of values.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }

  public IncidentItemBase treePath(String treePath) {
    
    this.treePath = treePath;
    return this;
  }

  /**
   * The path from process instance via flow node ids and flow node instance keys leading to this incident.
   * @return treePath
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TREE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTreePath() {
    return treePath;
  }


  @JsonProperty(JSON_PROPERTY_TREE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTreePath(String treePath) {
    this.treePath = treePath;
  }

  public IncidentItemBase tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the incident.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentItemBase incidentItemBase = (IncidentItemBase) o;
    return Objects.equals(this.processDefinitionId, incidentItemBase.processDefinitionId) &&
        Objects.equals(this.errorType, incidentItemBase.errorType) &&
        Objects.equals(this.errorMessage, incidentItemBase.errorMessage) &&
        Objects.equals(this.flowNodeId, incidentItemBase.flowNodeId) &&
        Objects.equals(this.creationTime, incidentItemBase.creationTime) &&
        Objects.equals(this.state, incidentItemBase.state) &&
        Objects.equals(this.treePath, incidentItemBase.treePath) &&
        Objects.equals(this.tenantId, incidentItemBase.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, errorType, errorMessage, flowNodeId, creationTime, state, treePath, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentItemBase {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    treePath: ").append(toIndentedString(treePath)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorType` to the URL query string
    if (getErrorType() != null) {
      try {
        joiner.add(String.format("%serrorType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeId` to the URL query string
    if (getFlowNodeId() != null) {
      try {
        joiner.add(String.format("%sflowNodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationTime` to the URL query string
    if (getCreationTime() != null) {
      try {
        joiner.add(String.format("%screationTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `treePath` to the URL query string
    if (getTreePath() != null) {
      try {
        joiner.add(String.format("%streePath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTreePath()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

