/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.MigrateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.MigrationPlan;
import io.camunda.zeebe.client.api.response.MigrateProcessInstanceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.response.MigrateProcessInstanceResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class MigrateProcessInstanceCommandImpl
implements MigrateProcessInstanceCommandStep1,
MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep {
    private final GatewayOuterClass.MigrateProcessInstanceRequest.Builder requestBuilder = GatewayOuterClass.MigrateProcessInstanceRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;

    public MigrateProcessInstanceCommandImpl(long processInstanceKey, GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        this.requestBuilder.setProcessInstanceKey(processInstanceKey);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep migrationPlan(long targetProcessDefinitionKey) {
        this.requestBuilder.setMigrationPlan(GatewayOuterClass.MigrateProcessInstanceRequest.MigrationPlan.newBuilder().setTargetProcessDefinitionKey(targetProcessDefinitionKey).build());
        return this;
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep migrationPlan(MigrationPlan migrationPlan) {
        List mappingInstructions = migrationPlan.getMappingInstructions().stream().map(mappingInstruction -> this.buildMappingInstruction(mappingInstruction.getSourceElementId(), mappingInstruction.getTargetElementId())).collect(Collectors.toList());
        this.requestBuilder.setMigrationPlan(GatewayOuterClass.MigrateProcessInstanceRequest.MigrationPlan.newBuilder().setTargetProcessDefinitionKey(migrationPlan.getTargetProcessDefinitionKey()).addAllMappingInstructions(mappingInstructions));
        return this;
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep addMappingInstruction(String sourceElementId, String targetElementId) {
        this.requestBuilder.getMigrationPlanBuilder().addMappingInstructions(this.buildMappingInstruction(sourceElementId, targetElementId));
        return this;
    }

    @Override
    public FinalCommandStep<MigrateProcessInstanceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<MigrateProcessInstanceResponse> send() {
        GatewayOuterClass.MigrateProcessInstanceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<MigrateProcessInstanceResponse, GatewayOuterClass.MigrateProcessInstanceResponse> future = new RetriableClientFutureImpl<MigrateProcessInstanceResponse, GatewayOuterClass.MigrateProcessInstanceResponse>(MigrateProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.MigrateProcessInstanceResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.MigrateProcessInstanceResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.MigrateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.MigrateProcessInstanceResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).migrateProcessInstance(request, streamObserver);
    }

    private GatewayOuterClass.MigrateProcessInstanceRequest.MappingInstruction buildMappingInstruction(String sourceElementId, String targetElementId) {
        ArgumentUtil.ensureNotNull("sourceElementId", sourceElementId);
        ArgumentUtil.ensureNotNull("targetElementId", targetElementId);
        return GatewayOuterClass.MigrateProcessInstanceRequest.MappingInstruction.newBuilder().setSourceElementId(sourceElementId).setTargetElementId(targetElementId).build();
    }
}

