/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import java.time.Duration;

public final class ArgumentUtil {
    public static void ensureNotNull(String property, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(property + " must not be null");
        }
    }

    public static void ensureNotEmpty(String property, String value) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException(property + " must not be empty");
        }
    }

    public static void ensureNotNullNorEmpty(String property, String value) {
        ArgumentUtil.ensureNotNull(property, value);
        ArgumentUtil.ensureNotEmpty(property, value);
    }

    public static void ensureGreaterThan(String property, long testValue, long comparisonValue) {
        if (testValue <= comparisonValue) {
            throw new IllegalArgumentException(property + " must be greater than " + comparisonValue);
        }
    }

    public static void ensureNotNegative(String property, Duration testValue) {
        if (testValue.isNegative()) {
            throw new IllegalArgumentException(String.format("%s must be not negative", property));
        }
    }

    public static void ensureNotZero(String property, Duration testValue) {
        if (testValue.isZero()) {
            throw new IllegalArgumentException(String.format("%s must be not zero", property));
        }
    }

    public static void ensurePositive(String property, Duration testValue) {
        ArgumentUtil.ensureNotNegative(property, testValue);
        ArgumentUtil.ensureNotZero(property, testValue);
    }
}

