/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.broker.transport.RequestReaderException;
import io.camunda.zeebe.protocol.impl.encoding.AuthInfo;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.impl.record.value.clock.ClockRecord;
import io.camunda.zeebe.protocol.impl.record.value.compensation.CompensationSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageCorrelationRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;

public class CommandApiRequestReader
implements AsyncApiRequestHandler.RequestReader<ExecuteCommandRequestDecoder> {
    static final Map<ValueType, Supplier<UnifiedRecordValue>> RECORDS_BY_TYPE = new EnumMap<ValueType, Supplier<UnifiedRecordValue>>(ValueType.class);
    private UnifiedRecordValue value;
    private final RecordMetadata metadata = new RecordMetadata();
    private final AuthInfo authInfo = new AuthInfo();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandRequestDecoder commandRequestDecoder = new ExecuteCommandRequestDecoder();

    @Override
    public void reset() {
        if (this.value != null) {
            this.value.reset();
        }
        this.metadata.reset();
    }

    @Override
    public ExecuteCommandRequestDecoder getMessageDecoder() {
        return this.commandRequestDecoder;
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (20 != templateId) {
            throw new RequestReaderException.InvalidTemplateException(this.messageHeaderDecoder.templateId(), templateId);
        }
        this.commandRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        this.metadata.protocolVersion(this.messageHeaderDecoder.version());
        Supplier<UnifiedRecordValue> recordSupplier = RECORDS_BY_TYPE.get(this.commandRequestDecoder.valueType());
        if (recordSupplier != null) {
            int valueOffset = this.commandRequestDecoder.limit() + ExecuteCommandRequestDecoder.valueHeaderLength();
            int valueLength = this.commandRequestDecoder.valueLength();
            this.value = recordSupplier.get();
            this.value.wrap(buffer, valueOffset, valueLength);
        }
        this.commandRequestDecoder.skipValue();
        if (this.commandRequestDecoder.limit() < buffer.capacity()) {
            int authOffset = this.commandRequestDecoder.limit() + ExecuteCommandRequestDecoder.authorizationHeaderLength();
            this.authInfo.wrap(buffer, authOffset, this.commandRequestDecoder.authorizationLength());
            this.metadata.authorization(this.authInfo);
        }
    }

    public UnifiedRecordValue value() {
        return this.value;
    }

    public RecordMetadata metadata() {
        return this.metadata;
    }

    static {
        RECORDS_BY_TYPE.put(ValueType.DEPLOYMENT, DeploymentRecord::new);
        RECORDS_BY_TYPE.put(ValueType.JOB, JobRecord::new);
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE, ProcessInstanceRecord::new);
        RECORDS_BY_TYPE.put(ValueType.MESSAGE, MessageRecord::new);
        RECORDS_BY_TYPE.put(ValueType.MESSAGE_BATCH, MessageBatchRecord::new);
        RECORDS_BY_TYPE.put(ValueType.JOB_BATCH, JobBatchRecord::new);
        RECORDS_BY_TYPE.put(ValueType.INCIDENT, IncidentRecord::new);
        RECORDS_BY_TYPE.put(ValueType.VARIABLE_DOCUMENT, VariableDocumentRecord::new);
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE_CREATION, ProcessInstanceCreationRecord::new);
        RECORDS_BY_TYPE.put(ValueType.DECISION_EVALUATION, DecisionEvaluationRecord::new);
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE_MODIFICATION, ProcessInstanceModificationRecord::new);
        RECORDS_BY_TYPE.put(ValueType.SIGNAL, SignalRecord::new);
        RECORDS_BY_TYPE.put(ValueType.COMMAND_DISTRIBUTION, CommandDistributionRecord::new);
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE_BATCH, ProcessInstanceBatchRecord::new);
        RECORDS_BY_TYPE.put(ValueType.RESOURCE_DELETION, ResourceDeletionRecord::new);
        RECORDS_BY_TYPE.put(ValueType.USER_TASK, UserTaskRecord::new);
        RECORDS_BY_TYPE.put(ValueType.PROCESS_INSTANCE_MIGRATION, ProcessInstanceMigrationRecord::new);
        RECORDS_BY_TYPE.put(ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionRecord::new);
        RECORDS_BY_TYPE.put(ValueType.MESSAGE_CORRELATION, MessageCorrelationRecord::new);
        RECORDS_BY_TYPE.put(ValueType.USER, UserRecord::new);
        RECORDS_BY_TYPE.put(ValueType.CLOCK, ClockRecord::new);
        RECORDS_BY_TYPE.put(ValueType.AUTHORIZATION, AuthorizationRecord::new);
    }
}

