/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.adminapi;

import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.protocol.management.AdminResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.ServerResponseImpl;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.MutableDirectBuffer;

public final class ApiResponseWriter
implements AsyncApiRequestHandler.ResponseWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final AdminResponseEncoder responseEncoder = new AdminResponseEncoder();
    private final ServerResponseImpl response = new ServerResponseImpl();
    private byte[] payload = null;
    private boolean hasPayload = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryWriteResponse(ServerOutput output, int partitionId, long requestId) {
        try {
            this.response.reset().writer((BufferWriter)this).setPartitionId(partitionId).setRequestId(requestId);
            output.sendResponse((ServerResponse)this.response);
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
    }

    public AdminResponseEncoder getResponseEncoder() {
        return this.responseEncoder;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        this.hasPayload = true;
    }

    public int getLength() {
        return 8 + AdminResponseEncoder.payloadHeaderLength() + (this.hasPayload ? this.payload.length : 0);
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset);
        this.headerEncoder.blockLength(this.responseEncoder.sbeBlockLength()).templateId(this.responseEncoder.sbeTemplateId()).schemaId(this.responseEncoder.sbeSchemaId()).version(this.responseEncoder.sbeSchemaVersion());
        this.responseEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength());
        if (this.hasPayload) {
            this.responseEncoder.putPayload(this.payload, 0, this.payload.length);
        }
    }
}

