/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ErrorResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.ServerResponseImpl;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Arrays;
import org.agrona.MutableDirectBuffer;
import org.slf4j.Logger;

public final class ErrorResponseWriter
implements BufferWriter {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private static final String UNSUPPORTED_MESSAGE_FORMAT = "Expected to handle only messages of type %s, but received one of type '%s'";
    private static final String PARTITION_LEADER_MISMATCH_FORMAT = "Expected to handle client message on the leader of partition '%d', but this node is not the leader for it";
    private static final String MALFORMED_REQUEST_FORMAT = "Expected to handle client message, but could not read it: %s";
    private static final String INVALID_CLIENT_VERSION_FORMAT = "Expected client to have protocol version less than or equal to '%d', but was '%d'";
    private static final String INVALID_MESSAGE_TEMPLATE_FORMAT = "Expected to handle only messages with template IDs of %s, but received one with id '%d'";
    private static final String INVALID_DEPLOYMENT_PARTITION_FORMAT = "Expected to deploy processes to partition '%d', but was attempted on partition '%d'";
    private static final String PROCESS_NOT_FOUND_FORMAT = "Expected to get process with %s, but no such process found";
    private static final String RESOURCE_EXHAUSTED = "Reached maximum capacity of requests handled";
    private static final String OUT_OF_DISK_SPACE = "Cannot accept requests for partition %d. Broker is out of disk space";
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ErrorResponseEncoder errorResponseEncoder = new ErrorResponseEncoder();
    private final ServerOutput output;
    private final ServerResponseImpl response = new ServerResponseImpl();
    private ErrorCode errorCode;
    private byte[] errorMessage;

    public ErrorResponseWriter() {
        this(null);
    }

    public ErrorResponseWriter(ServerOutput output) {
        this.output = output;
    }

    public <T> ErrorResponseWriter unsupportedMessage(T actualType, T ... expectedTypes) {
        return this.errorCode(ErrorCode.UNSUPPORTED_MESSAGE).errorMessage(String.format(UNSUPPORTED_MESSAGE_FORMAT, Arrays.toString(expectedTypes), actualType));
    }

    public ErrorResponseWriter partitionLeaderMismatch(int partitionId) {
        return this.errorCode(ErrorCode.PARTITION_LEADER_MISMATCH).errorMessage(String.format(PARTITION_LEADER_MISMATCH_FORMAT, partitionId));
    }

    public ErrorResponseWriter invalidClientVersion(int maximumVersion, int clientVersion) {
        return this.errorCode(ErrorCode.INVALID_CLIENT_VERSION).errorMessage(String.format(INVALID_CLIENT_VERSION_FORMAT, maximumVersion, clientVersion));
    }

    public ErrorResponseWriter internalError(String message, Object ... args) {
        return this.errorCode(ErrorCode.INTERNAL_ERROR).errorMessage(String.format(message, args));
    }

    public ErrorResponseWriter resourceExhausted() {
        return this.errorCode(ErrorCode.RESOURCE_EXHAUSTED).errorMessage(RESOURCE_EXHAUSTED);
    }

    public ErrorResponseWriter resourceExhausted(String message) {
        return this.errorCode(ErrorCode.RESOURCE_EXHAUSTED).errorMessage(message);
    }

    public ErrorResponseWriter outOfDiskSpace(int partitionId) {
        return this.errorCode(ErrorCode.RESOURCE_EXHAUSTED).errorMessage(String.format(OUT_OF_DISK_SPACE, partitionId));
    }

    public ErrorResponseWriter malformedRequest(Throwable e) {
        StringBuilder builder = new StringBuilder();
        do {
            builder.append(e.getMessage()).append("; ");
        } while ((e = e.getCause()) != null);
        return this.errorCode(ErrorCode.MALFORMED_REQUEST).errorMessage(String.format(MALFORMED_REQUEST_FORMAT, builder.toString()));
    }

    public ErrorResponseWriter invalidMessageTemplate(int actualTemplateId, int ... expectedTemplates) {
        return this.errorCode(ErrorCode.INVALID_MESSAGE_TEMPLATE).errorMessage(INVALID_MESSAGE_TEMPLATE_FORMAT, Arrays.toString(expectedTemplates), actualTemplateId);
    }

    public ErrorResponseWriter invalidDeploymentPartition(int expectedPartitionId, int actualPartitionId) {
        return this.errorCode(ErrorCode.INVALID_DEPLOYMENT_PARTITION).errorMessage(String.format(INVALID_DEPLOYMENT_PARTITION_FORMAT, expectedPartitionId, actualPartitionId));
    }

    public ErrorResponseWriter processNotFound(String processIdentifier) {
        return this.errorCode(ErrorCode.PROCESS_NOT_FOUND).errorMessage(String.format(PROCESS_NOT_FOUND_FORMAT, processIdentifier));
    }

    public ErrorResponseWriter mapWriteError(int partitionId, LogStreamWriter.WriteFailure error) {
        return switch (error) {
            default -> throw new MatchException(null, null);
            case LogStreamWriter.WriteFailure.CLOSED -> this.errorCode(ErrorCode.PARTITION_LEADER_MISMATCH).errorMessage("Expected to handle client message on the leader of partition '%d', but the writer is closed. Most likely, this node is not the leader for this partition.".formatted(partitionId));
            case LogStreamWriter.WriteFailure.WRITE_LIMIT_EXHAUSTED -> this.resourceExhausted(String.format("Failed to write client request to partition '%d', because the write limit is exhausted.", partitionId));
            case LogStreamWriter.WriteFailure.REQUEST_LIMIT_EXHAUSTED -> this.resourceExhausted(String.format("Failed to write client request to partition '%d', because the request limit is exhausted.", partitionId));
            case LogStreamWriter.WriteFailure.INVALID_ARGUMENT -> this.raiseInternalError("due to invalid entry.", partitionId);
        };
    }

    private ErrorResponseWriter raiseInternalError(String reason, int partitionId) {
        String message = "Failed to write client request to partition '%d', %s".formatted(partitionId, reason);
        LOG.debug(message);
        return this.internalError(message, new Object[0]);
    }

    public ErrorResponseWriter errorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public ErrorResponseWriter errorMessage(String errorMessage) {
        this.errorMessage = StringUtil.getBytes((String)errorMessage);
        return this;
    }

    public ErrorResponseWriter errorMessage(String errorMessage, Object ... args) {
        this.errorMessage = StringUtil.getBytes((String)String.format(errorMessage, args));
        return this;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public byte[] getErrorMessage() {
        return this.errorMessage;
    }

    public void tryWriteResponseOrLogFailure(ServerOutput output, int streamId, long requestId) {
        this.tryWriteResponse(output, streamId, requestId);
    }

    public void tryWriteResponseOrLogFailure(int streamId, long requestId) {
        this.tryWriteResponseOrLogFailure(this.output, streamId, requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryWriteResponse(ServerOutput output, int streamId, long requestId) {
        EnsureUtil.ensureNotNull((String)"error code", (Object)this.errorCode);
        EnsureUtil.ensureNotNull((String)"error message", (Object)this.errorMessage);
        try {
            this.response.reset().setPartitionId(streamId).writer((BufferWriter)this).setRequestId(requestId);
            output.sendResponse((ServerResponse)this.response);
        }
        finally {
            this.reset();
        }
    }

    public void tryWriteResponse(int streamId, long requestId) {
        this.tryWriteResponse(this.output, streamId, requestId);
    }

    public int getLength() {
        return 9 + ErrorResponseEncoder.errorDataHeaderLength() + this.errorMessage.length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageHeaderEncoder.wrap(buffer, offset);
        this.messageHeaderEncoder.blockLength(this.errorResponseEncoder.sbeBlockLength()).templateId(this.errorResponseEncoder.sbeTemplateId()).schemaId(this.errorResponseEncoder.sbeSchemaId()).version(this.errorResponseEncoder.sbeSchemaVersion());
        this.errorResponseEncoder.wrap(buffer, offset += this.messageHeaderEncoder.encodedLength());
        this.errorResponseEncoder.errorCode(this.errorCode).putErrorData(this.errorMessage, 0, this.errorMessage.length);
    }

    public void reset() {
        this.errorCode = null;
        this.errorMessage = null;
    }
}

