/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.RequestReaderException;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;
import org.slf4j.Logger;

public abstract class AsyncApiRequestHandler<R extends RequestReader<?>, W extends ResponseWriter>
extends Actor
implements RequestHandler {
    public static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private final Supplier<R> requestReaderSupplier;
    private final Supplier<W> responseWriterSupplier;
    private final Supplier<ErrorResponseWriter> errorResponseWriterSupplier = ErrorResponseWriter::new;

    protected AsyncApiRequestHandler(Supplier<R> requestReaderSupplier, Supplier<W> responseWriterSupplier) {
        this.requestReaderSupplier = requestReaderSupplier;
        this.responseWriterSupplier = responseWriterSupplier;
    }

    protected abstract ActorFuture<Either<ErrorResponseWriter, W>> handleAsync(int var1, long var2, R var4, W var5, ErrorResponseWriter var6);

    public final void onRequest(ServerOutput serverOutput, int partitionId, long requestId, DirectBuffer buffer, int offset, int length) {
        this.actor.submit(() -> this.handleRequest(serverOutput, partitionId, requestId, buffer, offset, length));
    }

    private void handleRequest(ServerOutput serverOutput, int partitionId, long requestId, DirectBuffer buffer, int offset, int length) {
        RequestReader requestReader = (RequestReader)this.requestReaderSupplier.get();
        ResponseWriter responseWriter = (ResponseWriter)this.responseWriterSupplier.get();
        ErrorResponseWriter errorResponseWriter = this.errorResponseWriterSupplier.get();
        requestReader.reset();
        responseWriter.reset();
        errorResponseWriter.reset();
        try {
            requestReader.wrap(buffer, offset, length);
        }
        catch (RequestReaderException.InvalidTemplateException e) {
            errorResponseWriter.invalidMessageTemplate(e.actualTemplate, e.expectedTemplate).tryWriteResponseOrLogFailure(serverOutput, partitionId, requestId);
            return;
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize message", (Throwable)e);
            errorResponseWriter.malformedRequest(e).tryWriteResponseOrLogFailure(serverOutput, partitionId, requestId);
            return;
        }
        try {
            ActorFuture<Either<ErrorResponseWriter, ResponseWriter>> resultFuture = this.handleAsync(partitionId, requestId, requestReader, responseWriter, errorResponseWriter);
            resultFuture.onComplete((result, throwable) -> {
                if (throwable != null) {
                    LOG.error("Error handling request on partition {}", (Object)partitionId, throwable);
                    errorResponseWriter.internalError("Failed to handle request due to internal error; see the broker logs for more", new Object[0]).tryWriteResponse(serverOutput, partitionId, requestId);
                }
                if (result.isLeft()) {
                    ((ErrorResponseWriter)result.getLeft()).tryWriteResponse(serverOutput, partitionId, requestId);
                } else {
                    ((ResponseWriter)result.get()).tryWriteResponse(serverOutput, partitionId, requestId);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error handling request on partition {}", (Object)partitionId, (Object)e);
            errorResponseWriter.internalError("Failed to handle request due to internal error; see the broker logs for more", new Object[0]).tryWriteResponse(serverOutput, partitionId, requestId);
        }
    }

    public static interface RequestReader<T extends MessageDecoderFlyweight>
    extends BufferReader {
        public void reset();

        public T getMessageDecoder();

        public void wrap(DirectBuffer var1, int var2, int var3);
    }

    public static interface ResponseWriter
    extends BufferWriter {
        public void tryWriteResponse(ServerOutput var1, int var2, long var3);

        public void reset();
    }
}

