/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;

public final class ZeebeDbPartitionTransitionStep
implements PartitionTransitionStep {
    private static final String RECOVERY_FAILED_ERROR_MSG = "Unexpected error occurred while recovering snapshot controller during leader partition install for partition %d";

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        RaftServer.Role currentRole = context.getCurrentRole();
        if (context.getZeebeDb() != null && (currentRole == RaftServer.Role.LEADER || targetRole == RaftServer.Role.INACTIVE)) {
            try {
                context.getStateController().closeDb();
                context.setZeebeDb(null);
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)e);
            }
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        CompletableActorFuture transitionFuture = new CompletableActorFuture();
        RaftServer.Role currentRole = context.getCurrentRole();
        if (targetRole == RaftServer.Role.INACTIVE) {
            return CompletableActorFuture.completed(null);
        }
        if (currentRole == RaftServer.Role.LEADER || currentRole == RaftServer.Role.INACTIVE || context.getZeebeDb() == null) {
            this.recoverDb(context, (CompletableActorFuture<Void>)transitionFuture);
        } else {
            transitionFuture.complete(null);
        }
        return transitionFuture;
    }

    @Override
    public String getName() {
        return "ZeebeDb";
    }

    private void recoverDb(PartitionTransitionContext context, CompletableActorFuture<Void> transitionFuture) {
        ActorFuture<ZeebeDb> recoverFuture = context.getStateController().recover();
        recoverFuture.onComplete((zeebeDb, error) -> {
            if (error != null) {
                transitionFuture.completeExceptionally((Throwable)new IllegalStateException(String.format(RECOVERY_FAILED_ERROR_MSG, context.getPartitionId()), (Throwable)error));
            } else {
                context.setZeebeDb((ZeebeDb)zeebeDb);
                transitionFuture.complete(null);
            }
        });
    }
}

