/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.engine.state.query.StateQueryService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.time.InstantSource;
import org.agrona.CloseHelper;

public final class QueryServicePartitionTransitionStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        RaftServer.Role currentRole = context.getCurrentRole();
        QueryService queryService = context.getQueryService();
        if (queryService != null && (currentRole == RaftServer.Role.LEADER || targetRole == RaftServer.Role.INACTIVE)) {
            try {
                CloseHelper.close((AutoCloseable)queryService);
                context.setQueryService(null);
                return CompletableActorFuture.completed(null);
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)e);
            }
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        RaftServer.Role currentRole = context.getCurrentRole();
        if (targetRole != RaftServer.Role.INACTIVE && (currentRole == RaftServer.Role.LEADER || context.getQueryService() == null)) {
            try {
                StateQueryService service = new StateQueryService(context.getZeebeDb(), InstantSource.system());
                context.setQueryService((QueryService)service);
                return CompletableActorFuture.completed(null);
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)e);
            }
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "QueryService";
    }
}

