/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;

public final class MetricsStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        CompositeMeterRegistry partitionMeterRegistry = (CompositeMeterRegistry)context.getPartitionMeterRegistry();
        MeterRegistry brokerMeterRegistry = context.getBrokerMeterRegistry();
        if (partitionMeterRegistry != null) {
            partitionMeterRegistry.clear();
            partitionMeterRegistry.remove(brokerMeterRegistry);
            partitionMeterRegistry.close();
            context.setPartitionMeterRegistry(null);
        }
        return context.getConcurrencyControl().createCompletedFuture();
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        MeterRegistry brokerRegistry = context.getBrokerMeterRegistry();
        CompositeMeterRegistry partitionRegistry = new CompositeMeterRegistry();
        partitionRegistry.config().commonTags((Iterable)Tags.of((String)"partition", (String)Integer.toString(context.getPartitionId())));
        partitionRegistry.add(brokerRegistry);
        context.setPartitionMeterRegistry((MeterRegistry)partitionRegistry);
        return context.getConcurrencyControl().createCompletedFuture();
    }

    @Override
    public String getName() {
        return "Metrics";
    }
}

