/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.configuration.FlowControlCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.stream.api.StreamClock;
import java.time.InstantSource;
import java.util.function.Supplier;

public final class LogStreamPartitionTransitionStep
implements PartitionTransitionStep {
    private final Supplier<LogStreamBuilder> logStreamBuilderSupplier;

    public LogStreamPartitionTransitionStep() {
        this(LogStream::builder);
    }

    LogStreamPartitionTransitionStep(Supplier<LogStreamBuilder> logStreamBuilderSupplier) {
        this.logStreamBuilderSupplier = logStreamBuilderSupplier;
    }

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        LogStream logStream = context.getLogStream();
        if (logStream != null && (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || targetRole == RaftServer.Role.INACTIVE)) {
            context.setStreamClock(null);
            context.getComponentHealthMonitor().removeComponent(logStream.getLogName());
            logStream.close();
            context.setLogStream(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (context.getLogStream() == null && targetRole != RaftServer.Role.INACTIVE || this.shouldInstallOnTransition(targetRole, context.getCurrentRole())) {
            Object clockSource = ActorClock.current() != null ? ActorClock.current() : InstantSource.system();
            context.setStreamClock(StreamClock.controllable((InstantSource)clockSource));
            context.setLogStream(this.buildLogStream(context));
            return CompletableActorFuture.completed(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "LogStream";
    }

    private LogStream buildLogStream(PartitionTransitionContext context) {
        FlowControlCfg flowControlCfg = context.getBrokerCfg().getFlowControl();
        return this.logStreamBuilderSupplier.get().withLogStorage((LogStorage)context.getLogStorage()).withLogName("logStream-" + context.getRaftPartition().name()).withPartitionId(context.getPartitionId()).withMaxFragmentSize(context.getMaxFragmentSize()).withActorSchedulingService(context.getActorSchedulingService()).withClock((InstantSource)context.getStreamClock()).withRequestLimit(flowControlCfg.getRequest() != null ? flowControlCfg.getRequest().buildLimit() : context.getBrokerCfg().getBackpressure().buildLimit()).withWriteRateLimit(flowControlCfg.getWrite() != null ? flowControlCfg.getWrite().buildLimit() : null).build();
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }
}

