/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.exporter.stream.ExporterPhase;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public class PartitionProcessingState {
    private static final String PERSISTED_PAUSE_STATE_FILENAME = ".processorPaused";
    private static final String PERSISTED_EXPORTER_PAUSE_STATE_FILENAME = ".exporterPaused";
    private boolean isProcessingPaused;
    private ExporterPhase exporterPhase;
    private final RaftPartition raftPartition;
    private boolean diskSpaceAvailable;

    public PartitionProcessingState(RaftPartition raftPartition) {
        this.raftPartition = raftPartition;
        this.initProcessingStatus();
        this.initExportingState();
    }

    public boolean isDiskSpaceAvailable() {
        return this.diskSpaceAvailable;
    }

    public void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.diskSpaceAvailable = diskSpaceAvailable;
    }

    public boolean isProcessingPaused() {
        return this.isProcessingPaused;
    }

    public void resumeProcessing() throws IOException {
        File persistedPauseState = this.getPersistedPauseState(PERSISTED_PAUSE_STATE_FILENAME);
        Files.deleteIfExists(persistedPauseState.toPath());
        if (!persistedPauseState.exists()) {
            this.isProcessingPaused = false;
        }
    }

    public void pauseProcessing() throws IOException {
        File persistedPauseState = this.getPersistedPauseState(PERSISTED_PAUSE_STATE_FILENAME);
        persistedPauseState.createNewFile();
        if (persistedPauseState.exists()) {
            this.isProcessingPaused = true;
        }
    }

    private File getPersistedPauseState(String filename) {
        return this.raftPartition.dataDirectory().toPath().resolve(filename).toFile();
    }

    private void initProcessingStatus() {
        this.isProcessingPaused = this.getPersistedPauseState(PERSISTED_PAUSE_STATE_FILENAME).exists();
    }

    public boolean shouldProcess() {
        return this.isDiskSpaceAvailable() && !this.isProcessingPaused();
    }

    public boolean isExportingPaused() {
        return this.exporterPhase.equals((Object)ExporterPhase.PAUSED);
    }

    public ExporterPhase getExporterPhase() {
        return this.exporterPhase;
    }

    public boolean pauseExporting() {
        try {
            this.setPersistedExporterPhase(ExporterPhase.PAUSED);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean softPauseExporting() {
        try {
            this.setPersistedExporterPhase(ExporterPhase.SOFT_PAUSED);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean resumeExporting() {
        try {
            this.setPersistedExporterPhase(ExporterPhase.EXPORTING);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    void setPersistedExporterPhase(ExporterPhase state) throws IOException {
        this.exporterPhase = state;
        if (state.equals((Object)ExporterPhase.EXPORTING)) {
            Files.deleteIfExists(this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME).toPath());
            return;
        }
        File persistedExporterPauseState = this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME);
        Files.writeString(persistedExporterPauseState.toPath(), (CharSequence)state.name(), StandardCharsets.UTF_8, StandardOpenOption.DSYNC, StandardOpenOption.CREATE);
    }

    private void initExportingState() {
        try {
            if (!this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME).exists()) {
                this.setPersistedExporterPhase(ExporterPhase.EXPORTING);
                this.exporterPhase = ExporterPhase.EXPORTING;
            } else {
                String state = Files.readString(this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME).toPath());
                if (state == null || state.isEmpty() || state.isBlank()) {
                    this.exporterPhase = ExporterPhase.PAUSED;
                    return;
                }
                this.exporterPhase = ExporterPhase.valueOf(state);
            }
        }
        catch (IOException e) {
            this.exporterPhase = ExporterPhase.EXPORTING;
        }
    }
}

