/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

final class PartitionConfigurationManager {
    private final Logger logger;
    private final PartitionContext context;
    private final Collection<ExporterDescriptor> exporterDescriptors;
    private final ConcurrencyControl executor;

    PartitionConfigurationManager(Logger logger, PartitionContext context, Collection<ExporterDescriptor> exporterDescriptors, ConcurrencyControl executor) {
        this.logger = logger;
        this.context = context;
        this.exporterDescriptors = exporterDescriptors;
        this.executor = executor;
    }

    ActorFuture<Void> disableExporter(String exporterId) {
        ActorFuture exportedDisabled = this.executor.createFuture();
        DynamicPartitionConfig updatedConfig = this.context.getDynamicPartitionConfig().updateExporting(config -> config.disableExporter(exporterId));
        this.context.setDynamicPartitionConfig(updatedConfig);
        ExporterDirector exporterDirector = this.context.getExporterDirector();
        if (exporterDirector != null) {
            exporterDirector.disableExporter(exporterId).onComplete((BiConsumer)exportedDisabled);
        } else {
            exportedDisabled.complete(null);
        }
        exportedDisabled.onComplete((nothing, error) -> {
            if (error == null) {
                this.logger.debug("Exporter {} disabled", (Object)exporterId);
            } else {
                this.logger.warn("Failed to disable exporter {}", (Object)exporterId, error);
            }
        });
        return exportedDisabled;
    }

    ActorFuture<Void> enableExporter(String exporterId, long metadataVersion, String initializeFrom) {
        ActorFuture exporterEnabled = this.executor.createFuture();
        Either<Exception, ExporterDescriptor> exporterDescriptor = this.validateAndGetDescriptor(exporterId, initializeFrom);
        exporterDescriptor.ifRightOrLeft(descriptor -> this.enableExporter(exporterId, metadataVersion, initializeFrom, (ExporterDescriptor)descriptor, (ActorFuture<Void>)exporterEnabled), throwable -> {
            this.logger.warn("Failed to enable exporter {}", (Object)initializeFrom, throwable);
            exporterEnabled.completeExceptionally((Throwable)throwable);
        });
        return exporterEnabled;
    }

    private Either<Exception, ExporterDescriptor> validateAndGetDescriptor(String exporterId, String initializeFrom) {
        if (initializeFrom == null) {
            return this.getExporterDescriptor(exporterId);
        }
        return this.getExporterDescriptor(exporterId).flatMap(descriptor -> this.getExporterDescriptor(initializeFrom).flatMap(otherDescriptor -> this.verifyValidInitialization((ExporterDescriptor)descriptor, (ExporterDescriptor)otherDescriptor)).map(ignore -> descriptor));
    }

    private void enableExporter(String exporterId, long metadataVersion, String initializeFrom, ExporterDescriptor descriptor, ActorFuture<Void> exporterEnabled) {
        DynamicPartitionConfig updatedConfig = this.context.getDynamicPartitionConfig().updateExporting(config -> config.enableExporter(exporterId, initializeFrom, metadataVersion));
        this.context.setDynamicPartitionConfig(updatedConfig);
        ExporterDirector exporterDirector = this.context.getExporterDirector();
        if (exporterDirector != null) {
            exporterDirector.enableExporter(exporterId, new ExporterDirector.ExporterInitializationInfo(metadataVersion, initializeFrom), descriptor).onComplete(exporterEnabled);
        } else {
            exporterEnabled.complete(null);
        }
        this.logger.debug("Exporter {} enabled with metadata version {} and initialized from {}", new Object[]{exporterId, metadataVersion, initializeFrom});
    }

    private Either<Exception, ExporterDescriptor> getExporterDescriptor(String exporterId) {
        Optional<ExporterDescriptor> descriptor = this.exporterDescriptors.stream().filter(d -> d.getId().equals(exporterId)).findFirst();
        return descriptor.map(Either::right).orElseGet(() -> Either.left((Object)new IllegalArgumentException("Exporter configuration of '%s' not found. Ensure the exporter is configured in the broker configuration".formatted(exporterId))));
    }

    private Either<Exception, Void> verifyValidInitialization(ExporterDescriptor exporterDescriptor, ExporterDescriptor otherExporterDescriptor) {
        if (!otherExporterDescriptor.isSameTypeAs(exporterDescriptor)) {
            return Either.left((Object)new IllegalArgumentException("Exporter '%s' is not of the same type as exporter '%s'. Cannot initialize from a different type of exporter".formatted(exporterDescriptor.getId(), otherExporterDescriptor.getId())));
        }
        return Either.right(null);
    }
}

