/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.engine;

import io.camunda.zeebe.broker.system.configuration.AuthorizationsCfg;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.engine.CachesCfg;
import io.camunda.zeebe.broker.system.configuration.engine.JobsCfg;
import io.camunda.zeebe.broker.system.configuration.engine.MessagesCfg;
import io.camunda.zeebe.broker.system.configuration.engine.ValidatorsCfg;
import io.camunda.zeebe.engine.EngineConfiguration;

public final class EngineCfg
implements ConfigurationEntry {
    private MessagesCfg messages = new MessagesCfg();
    private CachesCfg caches = new CachesCfg();
    private JobsCfg jobs = new JobsCfg();
    private ValidatorsCfg validators = new ValidatorsCfg();
    private AuthorizationsCfg authorizations = new AuthorizationsCfg();

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.messages.init(globalConfig, brokerBase);
        this.caches.init(globalConfig, brokerBase);
        this.jobs.init(globalConfig, brokerBase);
        this.validators.init(globalConfig, brokerBase);
        this.authorizations.init(globalConfig, brokerBase);
    }

    public MessagesCfg getMessages() {
        return this.messages;
    }

    public void setMessages(MessagesCfg messages) {
        this.messages = messages;
    }

    public CachesCfg getCaches() {
        return this.caches;
    }

    public void setCaches(CachesCfg caches) {
        this.caches = caches;
    }

    public JobsCfg getJobs() {
        return this.jobs;
    }

    public void setJobs(JobsCfg jobs) {
        this.jobs = jobs;
    }

    public ValidatorsCfg getValidators() {
        return this.validators;
    }

    public void setValidators(ValidatorsCfg validators) {
        this.validators = validators;
    }

    public AuthorizationsCfg getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(AuthorizationsCfg authorizations) {
        this.authorizations = authorizations;
    }

    public String toString() {
        return "EngineCfg{messages=" + String.valueOf(this.messages) + ", caches=" + String.valueOf(this.caches) + ", jobs=" + String.valueOf(this.jobs) + ", validators=" + String.valueOf(this.validators) + ", authorizations=" + String.valueOf(this.authorizations) + "}";
    }

    public EngineConfiguration createEngineConfiguration() {
        return new EngineConfiguration().setMessagesTtlCheckerBatchLimit(this.messages.getTtlCheckerBatchLimit()).setMessagesTtlCheckerInterval(this.messages.getTtlCheckerInterval()).setDrgCacheCapacity(this.caches.getDrgCacheCapacity()).setFormCacheCapacity(this.caches.getFormCacheCapacity()).setProcessCacheCapacity(this.caches.getProcessCacheCapacity()).setJobsTimeoutCheckerPollingInterval(this.jobs.getTimeoutCheckerPollingInterval()).setJobsTimeoutCheckerBatchLimit(this.jobs.getTimeoutCheckerBatchLimit()).setValidatorsResultsOutputMaxSize(this.validators.getResultsOutputMaxSize()).setEnableAuthorization(this.authorizations.isEnableAuthorization());
    }
}

