/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backup;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.backup.AzureBackupStoreConfig;
import io.camunda.zeebe.broker.system.configuration.backup.GcsBackupStoreConfig;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;

public class BackupStoreCfg
implements ConfigurationEntry {
    private BackupStoreType store = BackupStoreType.NONE;
    private S3BackupStoreConfig s3 = new S3BackupStoreConfig();
    private GcsBackupStoreConfig gcs = new GcsBackupStoreConfig();
    private AzureBackupStoreConfig azure = new AzureBackupStoreConfig();

    public S3BackupStoreConfig getS3() {
        return this.s3;
    }

    public void setS3(S3BackupStoreConfig s3) {
        this.s3 = s3;
    }

    public GcsBackupStoreConfig getGcs() {
        return this.gcs;
    }

    public void setGcs(GcsBackupStoreConfig gcs) {
        this.gcs = gcs;
    }

    public AzureBackupStoreConfig getAzure() {
        return this.azure;
    }

    public void setAzure(AzureBackupStoreConfig azure) {
        this.azure = azure;
    }

    public BackupStoreType getStore() {
        return this.store;
    }

    public void setStore(BackupStoreType store) {
        this.store = store;
    }

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.s3.init(globalConfig, brokerBase);
        this.gcs.init(globalConfig, brokerBase);
        this.azure.init(globalConfig, brokerBase);
    }

    public String toString() {
        return switch (this.store.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> "BackupStoreCfg{store=" + String.valueOf((Object)this.store) + "}";
            case 0 -> "BackupStoreCfg{store=" + String.valueOf((Object)this.store) + ", s3=" + String.valueOf(this.s3) + "}";
            case 1 -> "BackupStoreCfg{store=" + String.valueOf((Object)this.store) + ", gcs=" + String.valueOf(this.gcs) + "}";
            case 2 -> "BackupStoreCfg{store=" + String.valueOf((Object)this.store) + ", azure=" + String.valueOf(this.azure) + "}";
        };
    }

    public static enum BackupStoreType {
        S3,
        GCS,
        AZURE,
        NONE;

    }
}

