/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backup;

import io.camunda.zeebe.backup.azure.AzureBackupConfig;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.util.Objects;

public class AzureBackupStoreConfig
implements ConfigurationEntry {
    private String endpoint;
    private String accountName;
    private String accountKey;
    private String connectionString;
    private String basePath;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String algorithm) {
        this.connectionString = Objects.equals(algorithm, "none") ? null : algorithm;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public static AzureBackupConfig toStoreConfig(AzureBackupStoreConfig config) {
        return new AzureBackupConfig.Builder().withEndpoint(config.getEndpoint()).withAccountName(config.getAccountName()).withAccountKey(config.getAccountKey()).withConnectionString(config.getConnectionString()).withContainerName(config.getBasePath()).build();
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.accountName, this.accountKey, this.connectionString, this.basePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureBackupStoreConfig that = (AzureBackupStoreConfig)o;
        return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.accountName, that.accountName) && Objects.equals(this.accountKey, that.accountKey) && Objects.equals(this.connectionString, that.connectionString) && Objects.equals(this.basePath, that.basePath);
    }

    public String toString() {
        return "AzureBackupStoreConfig{endpoint='" + this.endpoint + "', accountName='" + this.accountName + "', accountKey='<redacted>', connectionString='<redacted>', basePath='" + this.basePath + "'}";
    }
}

