/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backpressure;

import io.camunda.zeebe.broker.system.configuration.backpressure.ThrottleCfg;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimit;
import java.time.Duration;
import java.util.Objects;

public class RateLimitCfg {
    private boolean enabled = false;
    private int limit;
    private Duration rampUp = Duration.ZERO;
    private ThrottleCfg throttling = new ThrottleCfg();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public RateLimit buildLimit() {
        return new RateLimit(this.enabled, this.limit, this.rampUp, new RateLimit.Throttling(this.throttling.isEnabled(), (long)this.throttling.getAcceptableBacklog(), (long)this.throttling.getMinimumLimit(), this.throttling.getResolution()));
    }

    public Duration getRampUp() {
        return this.rampUp;
    }

    public void setRampUp(Duration rampUp) {
        this.rampUp = rampUp;
    }

    public ThrottleCfg getThrottling() {
        return this.throttling;
    }

    public void setThrottling(ThrottleCfg throttling) {
        this.throttling = throttling;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.limit, this.rampUp, this.throttling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RateLimitCfg)) {
            return false;
        }
        RateLimitCfg that = (RateLimitCfg)o;
        return this.enabled == that.enabled && this.limit == that.limit && Objects.equals(this.rampUp, that.rampUp) && Objects.equals(this.throttling, that.throttling);
    }

    public String toString() {
        return "RateLimitCfg{enabled=" + this.enabled + ", limit=" + this.limit + ", rampUp=" + String.valueOf(this.rampUp) + ", throttling=" + String.valueOf(this.throttling) + "}";
    }
}

