/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backpressure;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.FixedLimit;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import com.netflix.concurrency.limits.limit.GradientLimit;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limit.WindowedLimit;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.backpressure.AIMDCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.FixedCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.Gradient2Cfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.GradientCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.LegacyVegasCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.VegasCfg;
import io.camunda.zeebe.logstreams.impl.flowcontrol.StabilizingAIMDLimit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class LimitCfg
implements ConfigurationEntry {
    private boolean enabled = true;
    @JsonProperty(value="useWindowed")
    private boolean useWindowed = true;
    private LimitAlgorithm algorithm = LimitAlgorithm.AIMD;
    private final AIMDCfg aimd = new AIMDCfg();
    private final FixedCfg fixed = new FixedCfg();
    private final VegasCfg vegas = new VegasCfg();
    private final GradientCfg gradient = new GradientCfg();
    private final Gradient2Cfg gradient2 = new Gradient2Cfg();
    private final LegacyVegasCfg legacyVegas = new LegacyVegasCfg();

    public boolean isEnabled() {
        return this.enabled;
    }

    public LimitCfg setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean useWindowed() {
        return this.useWindowed;
    }

    public void setUseWindowed(boolean useWindowed) {
        this.useWindowed = useWindowed;
    }

    public LimitAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = LimitAlgorithm.valueOf(algorithm.toUpperCase());
    }

    public void setAlgorithm(LimitAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public AIMDCfg getAimd() {
        return this.aimd;
    }

    public FixedCfg getFixed() {
        return this.fixed;
    }

    public VegasCfg getVegas() {
        return this.vegas;
    }

    public GradientCfg getGradient() {
        return this.gradient;
    }

    public Gradient2Cfg getGradient2() {
        return this.gradient2;
    }

    public LegacyVegasCfg getLegacyVegas() {
        return this.legacyVegas;
    }

    public Limit buildLimit() {
        StabilizingAIMDLimit baseLimit;
        if (!this.enabled) {
            return null;
        }
        switch (this.getAlgorithm().ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 4: {
                StabilizingAIMDLimit stabilizingAIMDLimit = LimitCfg.getAIMD(this.getAimd());
                break;
            }
            case 3: {
                StabilizingAIMDLimit stabilizingAIMDLimit = FixedLimit.of((int)this.getFixed().getLimit());
                break;
            }
            case 1: {
                StabilizingAIMDLimit stabilizingAIMDLimit = LimitCfg.getGradientLimit(this.getGradient());
                break;
            }
            case 2: {
                StabilizingAIMDLimit stabilizingAIMDLimit = LimitCfg.getGradient2Limit(this.getGradient2());
                break;
            }
            case 0: {
                StabilizingAIMDLimit stabilizingAIMDLimit = LimitCfg.getVegasLimit(this.getVegas());
                break;
            }
            case 5: {
                StabilizingAIMDLimit stabilizingAIMDLimit = baseLimit = LimitCfg.getLegacyVegasLimit(this.getLegacyVegas());
            }
        }
        if (this.useWindowed) {
            return WindowedLimit.newBuilder().build((Limit)baseLimit);
        }
        return baseLimit;
    }

    private static VegasLimit getLegacyVegasLimit(LegacyVegasCfg legacyVegas) {
        return VegasLimit.newBuilder().alpha(limit -> Math.max(3, (int)((double)limit.intValue() * legacyVegas.alphaLimit()))).beta(limit -> Math.max(6, (int)((double)limit.intValue() * legacyVegas.betaLimit()))).initialLimit(legacyVegas.initialLimit()).maxConcurrency(legacyVegas.getMaxConcurrency()).increase(limit -> limit + Math.log(limit)).decrease(limit -> limit - Math.log(limit)).build();
    }

    private static VegasLimit getVegasLimit(VegasCfg vegasCfg) {
        return VegasLimit.newBuilder().alpha(vegasCfg.getAlpha()).beta(vegasCfg.getBeta()).initialLimit(vegasCfg.getInitialLimit()).build();
    }

    private static Gradient2Limit getGradient2Limit(Gradient2Cfg gradient2Cfg) {
        return Gradient2Limit.newBuilder().rttTolerance(gradient2Cfg.getRttTolerance()).initialLimit(gradient2Cfg.getInitialLimit()).minLimit(gradient2Cfg.getMinLimit()).longWindow(gradient2Cfg.getLongWindow()).build();
    }

    private static GradientLimit getGradientLimit(GradientCfg gradientCfg) {
        return GradientLimit.newBuilder().minLimit(gradientCfg.getMinLimit()).initialLimit(gradientCfg.getInitialLimit()).rttTolerance(gradientCfg.getRttTolerance()).build();
    }

    private static StabilizingAIMDLimit getAIMD(AIMDCfg aimdCfg) {
        return StabilizingAIMDLimit.newBuilder().initialLimit(aimdCfg.getInitialLimit()).minLimit(aimdCfg.getMinLimit()).maxLimit(aimdCfg.getMaxLimit()).expectedRTT(aimdCfg.getRequestTimeout().toMillis(), TimeUnit.MILLISECONDS).backoffRatio(aimdCfg.getBackoffRatio()).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.useWindowed, this.algorithm, this.aimd, this.fixed, this.vegas, this.gradient, this.gradient2, this.legacyVegas});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LimitCfg)) {
            return false;
        }
        LimitCfg limitCfg = (LimitCfg)o;
        return this.enabled == limitCfg.enabled && this.useWindowed == limitCfg.useWindowed && this.algorithm == limitCfg.algorithm && Objects.equals(this.aimd, limitCfg.aimd) && Objects.equals(this.fixed, limitCfg.fixed) && Objects.equals(this.vegas, limitCfg.vegas) && Objects.equals(this.gradient, limitCfg.gradient) && Objects.equals(this.gradient2, limitCfg.gradient2) && Objects.equals(this.legacyVegas, limitCfg.legacyVegas);
    }

    public String toString() {
        return "LimitCfg{enabled=" + this.enabled + ", useWindowed=" + this.useWindowed + ", algorithm='" + String.valueOf((Object)this.algorithm) + "', aimd=" + String.valueOf(this.aimd) + ", fixed=" + String.valueOf(this.fixed) + ", vegas=" + String.valueOf(this.vegas) + ", gradient=" + String.valueOf(this.gradient) + ", gradient2=" + String.valueOf(this.gradient2) + ", legacyVegas=" + String.valueOf(this.legacyVegas) + "}";
    }

    public static enum LimitAlgorithm {
        VEGAS,
        GRADIENT,
        GRADIENT2,
        FIXED,
        AIMD,
        LEGACY_VEGAS;

    }
}

