/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.time.Duration;
import java.util.Set;

public final class ProcessingCfg
implements ConfigurationEntry {
    private static final int DEFAULT_PROCESSING_BATCH_LIMIT = 100;
    private Integer maxCommandsInBatch = 100;
    private boolean enableAsyncScheduledTasks = true;
    private Duration scheduledTaskCheckInterval = Duration.ofSeconds(1L);
    private Set<Long> skipPositions;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        if (this.maxCommandsInBatch < 1) {
            throw new IllegalArgumentException("maxCommandsInBatch must be >= 1 but was %s".formatted(this.maxCommandsInBatch));
        }
        if (!this.scheduledTaskCheckInterval.isPositive()) {
            throw new IllegalArgumentException("scheduledTaskCheckInterval must be positive but was %s".formatted(this.scheduledTaskCheckInterval));
        }
    }

    public int getMaxCommandsInBatch() {
        return this.maxCommandsInBatch;
    }

    public void setMaxCommandsInBatch(int maxCommandsInBatch) {
        this.maxCommandsInBatch = maxCommandsInBatch;
    }

    public boolean isEnableAsyncScheduledTasks() {
        return this.enableAsyncScheduledTasks;
    }

    public void setEnableAsyncScheduledTasks(boolean enableAsyncScheduledTasks) {
        this.enableAsyncScheduledTasks = enableAsyncScheduledTasks;
    }

    public Set<Long> skipPositions() {
        return this.skipPositions != null ? this.skipPositions : Set.of();
    }

    public void setSkipPositions(Set<Long> skipPositions) {
        this.skipPositions = skipPositions;
    }

    public String toString() {
        return "ProcessingCfg{maxCommandsInBatch=" + this.maxCommandsInBatch + ", enableAsyncScheduledTasks=" + this.enableAsyncScheduledTasks + ", scheduledTaskCheckInterval=" + String.valueOf(this.scheduledTaskCheckInterval) + "}";
    }

    public Duration getScheduledTaskCheckInterval() {
        return this.scheduledTaskCheckInterval;
    }

    public void setScheduledTaskCheckInterval(Duration scheduledTaskCheckInterval) {
        this.scheduledTaskCheckInterval = scheduledTaskCheckInterval;
    }
}

