/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.SecurityCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import org.springframework.util.unit.DataSize;

public final class NetworkCfg
implements ConfigurationEntry {
    public static final int DEFAULT_COMMAND_API_PORT = 26501;
    public static final int DEFAULT_INTERNAL_API_PORT = 26502;
    public static final DataSize DEFAULT_MAX_MESSAGE_SIZE = DataSize.ofMegabytes((long)4L);
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final String DEFAULT_ADVERTISED_HOST = Address.defaultAdvertisedHost().getHostAddress();
    private String host = null;
    private String advertisedHost = null;
    private int portOffset = 0;
    private DataSize maxMessageSize = DEFAULT_MAX_MESSAGE_SIZE;
    private final SocketBindingCfg.CommandApiCfg commandApi = new SocketBindingCfg.CommandApiCfg();
    private SocketBindingCfg.InternalApiCfg internalApi = new SocketBindingCfg.InternalApiCfg();
    private SecurityCfg security = new SecurityCfg();

    @Override
    public void init(BrokerCfg brokerCfg, String brokerBase) {
        this.applyDefaults();
        this.security.init(brokerCfg, brokerBase);
    }

    public void applyDefaults() {
        this.commandApi.applyDefaults(this);
        this.internalApi.applyDefaults(this);
    }

    public String getHost() {
        return this.host == null ? DEFAULT_HOST : this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAdvertisedHost() {
        if (this.advertisedHost != null) {
            return this.advertisedHost;
        }
        if (this.host != null) {
            return this.host;
        }
        return DEFAULT_ADVERTISED_HOST;
    }

    public void setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public long getMaxMessageSizeInBytes() {
        return this.maxMessageSize.toBytes();
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public SocketBindingCfg.CommandApiCfg getCommandApi() {
        return this.commandApi;
    }

    public SocketBindingCfg getInternalApi() {
        return this.internalApi;
    }

    public void setInternalApi(SocketBindingCfg.InternalApiCfg internalApi) {
        this.internalApi = internalApi;
    }

    public SecurityCfg getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityCfg security) {
        this.security = security;
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + "', portOffset=" + this.portOffset + "', maxMessageSize=" + String.valueOf(this.maxMessageSize) + ", commandApi=" + String.valueOf(this.commandApi) + ", internalApi=" + String.valueOf(this.internalApi) + ", security=" + String.valueOf(this.security) + "}";
    }
}

