/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public final class KeyStoreCfg
implements ConfigurationEntry {
    private File filePath;
    private String password;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        Path brokerBasePath = Path.of(brokerBase, new String[0]);
        if (this.filePath != null) {
            this.filePath = brokerBasePath.resolve(this.filePath.toPath()).toFile();
        }
    }

    public File getFilePath() {
        return this.filePath;
    }

    public KeyStoreCfg setFilePath(File filePath) {
        this.filePath = filePath;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public KeyStoreCfg setPassword(String password) {
        this.password = password;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.filePath, this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreCfg that = (KeyStoreCfg)o;
        return Objects.equals(this.filePath, that.filePath) && Objects.equals(this.password, that.password);
    }

    public String toString() {
        String passStr = this.password == null ? "" : "*****";
        return "KeyStoreCfg{filePath=" + String.valueOf(this.filePath) + ", password='" + passStr + "'}";
    }
}

